unit NewThreadView;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ImgList, ComCtrls, ToolWin, Katjusha, Menus;

type
	TNewThreadViewSortType = (nvtDepth, nvtTitle, nvtResCount, nvtThreadNum, nvtAsc, nvtDec);
	TNewThreadViewSortTypes = set of TNewThreadViewSortType;
  TNewThreadViewFrame = class(TFrame)
    ToolBar1: TToolBar;
    CallKachuButton: TToolButton;
    ListView: TListView;
    ToolBarImageList: TImageList;
    CloseButton: TToolButton;
    CallBrowserBtn: TToolButton;
		FindButton: TToolButton;
    PopupMenu: TPopupMenu;
    URLCopyMenuItem: TMenuItem;
    TitleAndURLCopyMenuItem: TMenuItem;
    procedure CallKachuButtonClick(Sender: TObject);
    procedure CallBrowserBtnClick(Sender: TObject);
    procedure ListViewColumnClick(Sender: TObject; Column: TListColumn);
		procedure ListViewCompare(Sender: TObject; Item1, Item2: TListItem;
			Data: Integer; var Compare: Integer);
    procedure FindButtonClick(Sender: TObject);
    procedure URLCopyMenuItemClick(Sender: TObject);
    procedure TitleAndURLCopyMenuItemClick(Sender: TObject);
  private
		{ Private 錾 }
		FURL: string; { FServerName + '/' + FBoardPath }
		FBoardPath: string;
		FServerName: string;
		FSearchText: string;	{ 镶 }
		FCaseInsensitive: Boolean;	{ 啶ʂ邩ǂ }
		SortType: TNewThreadViewSortTypes;
  public
		{ Public 錾 }
		procedure CreateList(const URL: string; Subject: T2chSubject);
		function ListItemToURL(const ListItem: TListItem): string;
		procedure RefreshColumn;
  end;

implementation

{$R *.dfm}

uses ClipBrd, AWKFunc, FavUtils, ThreadFind, bmRExp;

{ TNewThreadViewFrame }

procedure TNewThreadViewFrame.CreateList(const URL: string; Subject: T2chSubject);
var
	I: Integer;
begin
	FURL := URL;

	AWKMatch1('^(.+)/[^/]+$', FURL, FServerName);
	AWKMatch1('/([^/]+)$', FURL, FBoardPath);

	ListView.SortType := stNone;	{ \[g𖳌ɂ }
	ListView.Items.BeginUpdate;
	try
		ListView.Clear;

		for I := 0 to Subject.Count - 1 do
		begin
			with ListView.Items.Add do
			begin
				Caption := IntToStr(Subject[I].Depth);
				SubItems.Add(Subject[I].Title);
				SubItems.Add(IntToStr(Subject[I].ResCount));
				SubItems.Add(Subject.Strings[I]);
			end;
		end;
	finally
		ListView.Items.EndUpdate;
	end;
end;

procedure TNewThreadViewFrame.CallKachuButtonClick(Sender: TObject);
var
	I: Integer;
begin
	for I := 0 to ListView.Items.Count - 1 do
	begin
		if ListView.Items[I].Checked then
		begin
			CallKatjusha(ListItemToURL(ListView.Items[I]));
			ListView.Items[I].Checked := False;
		end;
	end;
end;

procedure TNewThreadViewFrame.CallBrowserBtnClick(Sender: TObject);
var
	I: Integer;
begin
	for I := 0 to ListView.Items.Count - 1 do
	begin
		if ListView.Items[I].Checked then
		begin
			CallBrowser(ListItemToURL(ListView.Items[I]));
			ListView.Items[I].Checked := False;
		end;
	end;
end;

procedure TNewThreadViewFrame.RefreshColumn;
begin
	ListView.Height := ListView.Height - 1;
end;

procedure TNewThreadViewFrame.ListViewColumnClick(Sender: TObject;
	Column: TListColumn);
var
	T: TNewThreadViewSortType;
	Shift: Boolean;
begin
	Shift := GetAsyncKeyState(VK_SHIFT) <> 0;
	ListView.SortType := stNone;

	T := nvtDepth;
	
	case Column.Index of
		0: T := nvtDepth;
		1: T := nvtTitle;
		2: T := nvtResCount;
	end;

  { VtgL[Ȃ^CgNbNŃXbh쐬\[g }
	if Shift and (T = nvtTitle) then
		T := nvtThreadNum;

	if T in SortType then
		if nvtAsc in SortType then
			SortType := SortType - [nvtAsc] + [nvtDec]
		else
			SortType := SortType - [nvtDec] + [nvtAsc];

	if not (T in SortType) then
		SortType := [T, nvtAsc];
	
	ListView.SortType := stData;
	ListView.SortType := stNone;	{ \[g㖳ɂ }
end;

procedure TNewThreadViewFrame.ListViewCompare(Sender: TObject; Item1,
	Item2: TListItem; Data: Integer; var Compare: Integer);
begin
	Compare := 0;

	if nvtTitle in SortType then
	begin
		if Item1.SubItems[0] < Item2.SubItems[0] then
			Compare := -1
		else if Item1.SubItems[0] > Item2.SubItems[0] then
			Compare := 1;
	end else if nvtResCount in SortType then
	begin
		if StrToInt(Item1.SubItems[1]) < StrToInt(Item2.SubItems[1]) then
			Compare := -1
		else if StrToInt(Item1.SubItems[1]) > StrToInt(Item2.SubItems[1]) then
			Compare := 1;
	end else if nvtThreadNum in SortType then
	begin
		if StrToCurr(Item1.SubItems[2]) < StrToCurr(Item2.SubItems[2]) then
			Compare := -1
		else if StrToCurr(Item1.SubItems[2]) > StrToCurr(Item2.SubItems[2]) then
			Compare := 1;
	end else if nvtDepth in SortType then
	begin
		if StrToInt(Item1.Caption) < StrToInt(Item2.Caption) then
			Compare := -1
		else if StrToInt(Item1.Caption) > StrToInt(Item2.Caption) then
			Compare := 1;
	end;

	if nvtDec in SortType then
		Compare := -Compare;
end;

procedure TNewThreadViewFrame.FindButtonClick(Sender: TObject);
var
	I, RIndex, RLength: Integer;
begin
	if TThreadFindDlg.Execute(Owner, FSearchText, FCaseInsensitive) then
	begin
		with ListView do
		begin
			Items.BeginUpdate;
			try
				for I := Items.Count - 1 downto 0 do
				begin
					if bmAWKMatch(FSearchText, FCaseInsensitive, Items[I].SubItems[0], RIndex, RLength) = 0 then
						Items.Delete(I);
				end;
			finally
				Items.EndUpdate;
			end;
		end;
	end;
end;

function TNewThreadViewFrame.ListItemToURL(
  const ListItem: TListItem): string;
begin
	{ ̏LĂACełȂƋȂ }
	Assert(ListView.Items = ListItem.Owner);

	Result := Format('http://%s/test/read.cgi/%s/%s/', [FServerName, FBoardPath, ListItem.SubItems[2]]);
end;

procedure TNewThreadViewFrame.URLCopyMenuItemClick(Sender: TObject);
var
	Item: TListItem;
	URL: string;
begin
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			URL := URL + ListItemToURL(Item) + #13#10;
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;

	if URL <> '' then
		Clipbrd.Clipboard.AsText := URL;
end;

procedure TNewThreadViewFrame.TitleAndURLCopyMenuItemClick(
  Sender: TObject);
var
	Item: TListItem;
	URL: string;
begin
	with ListView do
	begin
		if Selected = nil then Exit;
		Item := Selected;
		repeat
			URL := URL + Item.SubItems[0] + #13#10;
			URL := URL + ListItemToURL(Item) + #13#10;
			Item := GetNextItem(Item, sdAll, [isSelected]);
		until Item = nil;
	end;

	if URL <> '' then
		Clipbrd.Clipboard.AsText := URL;
end;

end.

