unit FavMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, Menus, ComCtrls, ExtCtrls, IniFiles, Katjusha, ActnList, StdActns,
  ImgList, ActiveX, FavUtils, ThFrame, BrowserView, BoardView, ToolWin,
  NewThreadView, CommCtrl, FavTypes;

type
	TLibLoadThread = class;
	TKatfavMainForm = class(TForm)
    MainMenu: TMainMenu;
    StatusBar: TStatusBar;
    Splitter1: TSplitter;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    ActionList: TActionList;
    FileExit: TFileExit;
		Edit1: TMenuItem;
    Undo1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    A1: TMenuItem;
    FileDeleteLib: TAction;
    N4: TMenuItem;
    K1: TMenuItem;
    Delete2: TMenuItem;
    FileSaveAll: TAction;
    FileSaveAll1: TMenuItem;
    NewThreadLib: TAction;
    N2: TMenuItem;
    Tool1: TMenuItem;
    ToolThreadSort: TAction;
    HelpAboutAction: TAction;
    Help1: TMenuItem;
    About1: TMenuItem;
    ToolSelectKage: TAction;
    A2: TMenuItem;
    ToolSortLib: TAction;
    MainMenuImageList: TImageList;
    ToolOption: TAction;
    FileArchive: TAction;
    N6: TMenuItem;
    O1: TMenuItem;
    L1: TMenuItem;
    N7: TMenuItem;
    EditSortMenuItem: TMenuItem;
    EditSortTitleMenuItem: TMenuItem;
    EditSortThreadNumMenuItem: TMenuItem;
    EditSortLevelMenuItem: TMenuItem;
    EditSortBoardMenuItem: TMenuItem;
    EditSortMemoMenuItem: TMenuItem;
    RightPanel: TPanel;
    Splitter2: TSplitter;
    ViewShowBrowserView: TAction;
    BoardView: TBoardViewFrame;
    ToolGetResStatus: TAction;
    O2: TMenuItem;
    ResCheckTimer: TTimer;
    EditSortCheckResMenuItem: TMenuItem;
    BrowserView: TBrowserViewFrame;
    ToolGetResStatusSubject: TAction;
    N8: TMenuItem;
    EditCustomSort: TAction;
    A4: TMenuItem;
    Splitter3: TSplitter;
    NewThreadView: TNewThreadViewFrame;
    ThreadListFrame1: TThreadListFrame;
    W1: TMenuItem;
    Show1: TMenuItem;
    ShowNewResPanelMenuItem: TMenuItem;
    ViewShowNewThreadView: TAction;
    CustomSortSepMenuItem: TMenuItem;
    CoolBar: TCoolBar;
    ToolBar: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolKickKatjusha: TAction;
    ViewShowToolBar: TAction;
    T1: TMenuItem;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    FlagNormalAction: TAction;
    FlagDatDropAction: TAction;
    FlagFavoriteAction: TAction;
    FlagMenu: TMenuItem;
    N5: TMenuItem;
    DATD1: TMenuItem;
    F2: TMenuItem;
    ToolAllThreadListCreate: TAction;
    A5: TMenuItem;
    FileReloadThreadLibs: TAction;
    N9: TMenuItem;
    ID1: TMenuItem;
    A3: TMenuItem;
    BoardToolBar: TToolBar;
    ToolButton11: TToolButton;
    I1: TMenuItem;
    B1: TMenuItem;
    N3: TMenuItem;
    N10: TMenuItem;
    BoardToolButtonPopupMenu: TPopupMenu;
    BoardToolButtonDeleteMenuItem: TMenuItem;
    N11: TMenuItem;
    BoardToolButtonCustomizeMenuItem: TMenuItem;
    Window1: TMenuItem;
    WindowCloseAll: TAction;
    C1: TMenuItem;
    N12: TMenuItem;
    BoardToolButtonURLCopyMenuItem: TMenuItem;
    BoardToolButtonBrowerOpenMenuItem: TMenuItem;
    BoardToolButtonImageList: TImageList;
    BoardToolButtonThreadListOpenMenuItem: TMenuItem;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    HelpOpenHomepage: TAction;
    W2: TMenuItem;
    ToolFullTextSearch: TAction;
    S1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FileSaveAllExecute(Sender: TObject);
    procedure NewThreadLibExecute(Sender: TObject);
    procedure HelpAboutActionExecute(Sender: TObject);
    procedure ToolSelectKageExecute(Sender: TObject);
    procedure ToolSortLibExecute(Sender: TObject);
    procedure FileArchiveExecute(Sender: TObject);
    procedure ToolOptionExecute(Sender: TObject);
    procedure EditSortTitleMenuItemClick(Sender: TObject);
    procedure EditSortThreadNumMenuItemClick(Sender: TObject);
    procedure EditSortLevelMenuItemClick(Sender: TObject);
    procedure EditSortBoardMenuItemClick(Sender: TObject);
    procedure EditSortMemoMenuItemClick(Sender: TObject);
    procedure ThreadListFrame1ListViewDblClick(Sender: TObject);
    procedure ThreadListFrame1FilePropertyExecute(Sender: TObject);
    procedure ViewShowBrowserViewExecute(Sender: TObject);
    procedure BoardViewFavTreeViewClick(Sender: TObject);
    procedure BoardViewFavTreeViewDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure BrowserViewCloseButtonClick(Sender: TObject);
    procedure ToolGetResStatusExecute(Sender: TObject);
    procedure ResCheckTimerTimer(Sender: TObject);
    procedure EditSortCheckResMenuItemClick(Sender: TObject);
    procedure BoardViewBoardTreeViewClick(Sender: TObject);
    procedure ToolGetResStatusSubjectExecute(Sender: TObject);
    procedure StatusBarResize(Sender: TObject);
    procedure ThreadListFrame1FileSelectBoardExecute(Sender: TObject);
    procedure EditCustomSortExecute(Sender: TObject);
    procedure ViewShowNewThreadViewUpdate(Sender: TObject);
    procedure ToolGetResStatusUpdate(Sender: TObject);
    procedure ViewShowNewThreadViewExecute(Sender: TObject);
    procedure NewThreadViewCloseButtonClick(Sender: TObject);
    procedure FileActionUpdate(Sender: TObject);
    procedure ToolSortLibUpdate(Sender: TObject);
    procedure ThreadListFrame1EditMoveSelServerExecute(Sender: TObject);
    procedure ThreadListFrame1EditDeleteLogExecute(Sender: TObject);
    procedure ViewShowToolBarExecute(Sender: TObject);
    procedure ToolKickKatjushaExecute(Sender: TObject);
    procedure ToolKickKatjushaUpdate(Sender: TObject);
    procedure FlagNormalActionExecute(Sender: TObject);
    procedure FlagDatDropActionExecute(Sender: TObject);
    procedure FlagFavoriteActionExecute(Sender: TObject);
    procedure ToolAllThreadListCreateExecute(Sender: TObject);
    procedure FileReloadThreadLibsExecute(Sender: TObject);
    procedure FileArchiveUpdate(Sender: TObject);
    procedure BoardViewFavPopupMenuPopup(Sender: TObject);
    procedure BoardToolButtonDeleteMenuItemClick(Sender: TObject);
    procedure BoardToolButtonCustomizeMenuItemClick(Sender: TObject);
    procedure Window1Click(Sender: TObject);
    procedure WindowCloseAllExecute(Sender: TObject);
    procedure BoardToolButtonPopupMenuPopup(Sender: TObject);
    procedure BoardToolButtonBrowerOpenMenuItemClick(Sender: TObject);
    procedure BoardToolButtonURLCopyMenuItemClick(Sender: TObject);
    procedure BoardToolButtonThreadListOpenMenuItemClick(Sender: TObject);
    procedure HelpOpenHomepageExecute(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormDeactivate(Sender: TObject);
    procedure ToolFullTextSearchExecute(Sender: TObject);
	private
		{ Private 錾 }
		FavoriteList: TStringList;
		FKatjusha: TKatjusha;
		IniFile: TKatfavIniFile;
		FMasterIndex: T2chIndexList;
		LoadingLibName: string;
		LibLoadThread: TLibLoadThread;
		ResCheckThread: TResCheckThread;
		NowLoading: Boolean;
		BrowserViewShowFirst: Boolean;
		ScriptManager: TKatfavScriptManager;
		CustomSortList: T2chCustomSortObjectList;
		FListProgressBar: TProgressBar;	{ Xg\pvOXo[ }
		FBoardButtonManager: TBoardButtonManager;	{ {^Ǘ }
		FWindowList: TWindowMenuList;	{ EBhEj[Ǘ }
		FVersion: string; { o[W }
		FFullTextSearchConfig: TFullTextSearchConfig;	{ XbhSݒ }
		procedure UpdateIniFile(Direction: Boolean);
		procedure BeginLibraryLoading(const LibName: string);
		procedure EndLibraryLoading(Index: Integer; IndexList: T2chIndexList);
		procedure LibraryLoadedAll;
    procedure SetStatusText(const Value: string);
		procedure SetCurrentBoard(const Value: string);
		procedure RefreshCustomSortMenu;
		procedure CustomSortMenuClick(Sender: TObject);
		procedure BoardButtonClick(Sender: TObject);
		procedure ReflectNoLoadFavorites(FavList: TStringList; NoLoadList: TStringList);
		function BoardToolButtonToPath(Button: TToolButton): string;
		function BoardToolButtonToURL(Button: TToolButton): string;
		function ComponentToBoardToolButton(AComponent: TComponent): TToolButton;
		procedure SaveAll;	{ Sĕۑ }
	public
		{ Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
		procedure ThreadCatchError(const Msg: string);
		procedure AddBoardButton(ButtonType: TBoardButtonType; BoardName, BoardURL: string);
		procedure AddSubForm(AForm: TForm);			{ TutH[̒ǉ }
		procedure RemoveSubForm(AForm: TForm);  { TutH[̍폜 }
		procedure Refresh(Index: T2chThreadIndex);	{ XbhXg̍XV }
		property StatusText: string write SetStatusText;
		property CurrentBoard: string write SetCurrentBoard;
		property MasterIndex: T2chIndexList read FMasterIndex write FMasterIndex;
		property ListProgressBar: TProgressBar read FListProgressBar;
		property Version: string read FVersion;
		property Katjusha: TKatjusha read FKatjusha;
	end;

	TLibLoadThread = class(TThread)
	private
		Count: Integer;
		LibName: string;
		IndexList: T2chIndexList;
		FavoriteList: TStringList;
		ErrorMessage: string;
	protected
		procedure Execute; override;
		procedure BeginLibraryLoading;
		procedure EndLibraryLoading;
		procedure LibraryLoadedAll;
		procedure CatchError;
	public
		constructor Create(CreateSuspended: Boolean);
		destructor Destroy; override;
	end;

var
	KatfavMainForm: TKatfavMainForm;

implementation

uses DateUtils, Clipbrd, ThProp, NewThLib, AboutDlg, KageChkDlg, ThLibSort, ThreadView,
	ThArcDlg, OptDlg, IdHttp, IdException, IdHTTPHeaderInfo, StrUtils, Contnrs,
	CustomSortList, RestartKachu, AllThreadSearchDlg, AwkFunc,
  ThreadList, FullTextSearchConfig, FullTextSearch;

{$R *.dfm}

const
	KATFAV_HOMEPAGE_URL = 'http://katfav.sourceforge.jp/';

procedure TKatfavMainForm.FormCreate(Sender: TObject);
var
	VerInfo: TVersionInformation;
begin
	LongTimeFormat := 'hh:nn:ss';

	FavoriteList := TStringList.Create;
	IniFile := TKatfavIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
	CustomSortList := T2chCustomSortObjectList.Create;
	FFullTextSearchConfig := TFullTextSearchConfig.Create;

	{ o[Wǂݍ }
	VerInfo := TVersionInformation.Create(Application.ExeName);
	try
		FVersion := Format('%d.%.2d Build #%d', [VerInfo.Major, VerInfo.Minor, VerInfo.Build]);
		Caption := Caption + ' ' + FVersion;
		FKatjusha.GetCommParams.UserAgent := Format('Monazilla/1.00 (katfav/%d.%.2d.%.2d)', [VerInfo.Major, VerInfo.Minor, VerInfo.Build]);
	finally
		VerInfo.Free;
	end;
	
	{ `fBNgۑ }
	TKatjusha.SetKatjushaBaseDir(GetCurrentDir);

	{ pathinfo.txtǂݍ }
	try
		FKatjusha.LoadPathInfo(TKatjusha.GetKatjushaBaseDir + 'pathinfo.txt');
	except
		on EFOpenError do
			{ t@CJȂƂ͖ };
		else
			raise;
	end;
	
	{ INIt@C̓ǂݍ }
	UpdateIniFile(True);

	with BoardView.ClipBoardNode do
	begin
		Data := T2chIndexList.Create(FMasterIndex);
		T2chIndexList(Data).LibName := 'Nbv{[h';
		ThreadListFrame1.ClipBoard := Data;
	end;

	{ XNvgǂݍ }
	try
		ScriptManager := TKatfavScriptManager.Create(ChangeFileExt(Application.ExeName, '.js'));
	except
		on E: EKatfavScriptError do
		begin
			ShowMessage(E.Message);
			FreeAndNil(ScriptManager);
		end;
	end;

	{ JX^\[gݒ̓ǂݍ }
	try
		CustomSortList.LoadFromXML(
			IncludeTrailingPathDelimiter(ExtractFilePath(Application.ExeName)) + 'CustomSort.xml');
	except
		on Exception do { G[͖ };
	end;
	RefreshCustomSortMenu;

	{ c[o[̕\/\ }
	ViewShowToolBarExecute(Self);

	{ {^ݒ }
	FBoardButtonManager := TBoardButtonManager.Create(BoardToolBar);
	FBoardButtonManager.PopupMenu := BoardToolButtonPopupMenu;
	FBoardButtonManager.OnClick := BoardButtonClick;
	FBoardButtonManager.List := IniFile.BoardButtonList;

	{ EBhEj[ݒ }
	FWindowList := TWindowMenuList.Create(Window1);
	
	{ CoolBar̐ݒ }
	IniFile.CoolBarBandParams.Load(CoolBar);

	{ VKX񍐃r[̃TCYݒ }
	NewThreadView.Height := RightPanel.ClientHeight div 3;

	{ Xg\pvOXo[̍쐬 }
	FListProgressBar := TProgressBar.Create(StatusBar);
	with FListProgressBar do
	begin
		Parent := StatusBar;
		Top := 2;
		Height := StatusBar.Height - 2;
		Left := 0;
		Width := 100;
	end;

	{ V`FbNpXbh쐬 }
	ResCheckThread := TResCheckThread.Create(False);
	ResCheckThread.ListView := ThreadListFrame1.ListView;

  { Cɓǂݍ܂Ȃꍇ͂łʂ }
	if IniFile.NoLoadFavorites then
	begin
		{ {[h^uɐ؂ւ }
		StatusText := 'Xbhqɂǂݍ݂܂łB';
		BoardView.ChangeBoardTab;
		Exit;
	end;

	{ Xbhqɓǂݍ݃Xbh쐬 }
	LibLoadThread := TLibLoadThread.Create(True);

	FKatjusha.GetFavoriteList(FavoriteList, False);
	FavoriteList.Sort;
	FavoriteList.Insert(0, 'favorite');
	ReflectNoLoadFavorites(FavoriteList, IniFile.NoLoadFavoritesDetail);
	LibLoadThread.FavoriteList.Assign(FavoriteList);

	{ ߋOqɓǂݍ݃Xbhs }
	NowLoading := True;
	LibLoadThread.Resume;
end;

procedure TKatfavMainForm.FormDestroy(Sender: TObject);
begin
	if Assigned(LibLoadThread) then
	begin
		LibLoadThread.Terminate;
		LibLoadThread.WaitFor;
		LibLoadThread.Free;
	end;

	if Assigned(ResCheckThread) then
	begin
		ResCheckThread.Terminate;
		if ResCheckThread.Suspended then ResCheckThread.Resume;
		ResCheckThread.WaitFor;
		ResCheckThread.Free;
	end;

	{ {^̕ۑ }
	IniFile.BoardButtonList := FBoardButtonManager.List;

	{ CoolBar̕ۑ }
	IniFile.CoolBarBandParams.Save(CoolBar);

	try
		UpdateIniFile(False);
	except
		on EFOpenError do
			{ JȂƂ͖ };
	end;

	try
		CustomSortList.SaveToXML(
			IncludeTrailingPathDelimiter(ExtractFilePath(Application.ExeName)) + 'CustomSort.xml');
	except
		on Exception do { G[͖ };
	end;

	{ {^̑S폜 }
	FBoardButtonManager.Clear;

	{ EBhEj[ }
	FreeAndNil(FWindowList);

	FreeAndNil(FFullTextSearchConfig);
	FreeAndNil(FBoardButtonManager);
	FreeAndNil(CustomSortList);
	FreeAndNil(ScriptManager);
end;

procedure TKatfavMainForm.FileSaveAllExecute(Sender: TObject);
begin
	if Application.MessageBox('ۑ܂B낵łH', PChar(Application.Title), MB_YESNO or MB_ICONEXCLAMATION) <> IDYES then
		Exit;

	SaveAll;
end;

procedure TKatfavMainForm.NewThreadLibExecute(Sender: TObject);
var
	Item: TTreeNode;
	Index: T2chIndexList;
begin
	if NewThreadLibDlg.ShowModal = mrOk then
	begin
		Index := T2chIndexList.Create;
		Index.LibName := NewThreadLibDlg.LibName;
		Item := BoardView.FavTreeView.Items.AddChild(BoardView.RootNode, NewThreadLibDlg.LibName);
		Item.Data := Pointer(Index);
	end;
end;

procedure TKatfavMainForm.HelpAboutActionExecute(Sender: TObject);
begin
	TAboutDialog.Execute;
end;

procedure TKatfavMainForm.ToolSelectKageExecute(Sender: TObject);
begin
	if TKageLogCheckDlg.Execute(ThreadListFrame1.ListView) then
		ThreadListFrame1.ListView.SetFocus;
end;

procedure TKatfavMainForm.ToolSortLibExecute(Sender: TObject);
begin
	TThreadLibSortDlg.Execute(FavoriteList);
end;

{ TLibLoadThread }

procedure TLibLoadThread.BeginLibraryLoading;
begin
	KatfavMainForm.BeginLibraryLoading(LibName);
end;

procedure TLibLoadThread.CatchError;
begin
	KatfavMainForm.ThreadCatchError(ErrorMessage);
end;

constructor TLibLoadThread.Create(CreateSuspended: Boolean);
begin
	inherited;
	{ sI玩gj }
	{ FreeOnTerminate := True; } {ɉȂ}
	FavoriteList := TStringList.Create;
end;

destructor TLibLoadThread.Destroy;
begin
	FreeAndNil(FavoriteList);
	inherited;
end;

procedure TLibLoadThread.EndLibraryLoading;
begin
	KatfavMainForm.EndLibraryLoading(Count, IndexList);
end;

procedure TLibLoadThread.Execute;
var
	I: Integer;
begin
	try
		try
			for I := 0 to FavoriteList.Count - 1 do
			begin
				{ MasterIndexLoadFromStreamłgĂȂ̂łԂXbhZ[tȂ͂ }
				IndexList := T2chIndexList.Create(KatfavMainForm.MasterIndex);
				LibName := FavoriteList[I];
				if LibName = 'favorite' then
					LibName := 'Cɓ';
				Synchronize(BeginLibraryLoading);
				IndexList.LoadFromFile(TKatjusha.GetKatjushaBaseDir + FavoriteList[I] + '.idx');
				IndexList.DisplayName := LibName;
				Count := I;
				Synchronize(EndLibraryLoading);
				IndexList := nil;

				if Terminated then Exit;
			end;
		except
			on E: Exception do begin
				ErrorMessage := E.Message;
				Synchronize(CatchError);
			end;
		end;
	finally
		{ ߋOɓǂݍ݊ }
		Synchronize(LibraryLoadedAll);

		IndexList.Free;
	end;
end;

procedure TKatfavMainForm.BeginLibraryLoading(const LibName: string);
begin
	LoadingLibName := LibName;
	StatusText := Format('''%s''ǂݍݒłc', [LibName]);
end;

procedure TKatfavMainForm.EndLibraryLoading(Index: Integer; IndexList: T2chIndexList);
begin
{	FavoriteList.Objects[Index] := IndexList;}
	with BoardView.FavTreeView.Items.AddChild(BoardView.RootNode, LoadingLibName) do
	begin
		Data := IndexList;
		{ 擪̏ɂI }
		if Index = 0 then Selected := True;
	end;

	{ ŏ̏(Cɓ)̏ꍇ͕\ }
	if Index = 0 then
		ThreadListFrame1.Selected := IndexList;
end;

procedure TKatfavMainForm.LibraryLoadedAll;
begin
	NowLoading := False;
	
	StatusText := 'ǂݍ݊';
	BoardView.FavTreeView.FullExpand;
end;

procedure TLibLoadThread.LibraryLoadedAll;
begin
	KatfavMainForm.LibraryLoadedAll;
end;

procedure TKatfavMainForm.UpdateIniFile(Direction: Boolean);
begin
	{ INIt@C̃ftHglݒ }
	ThreadListFrame1.IniFileUpdate(IniFile, False);
	IniFile.ThreadListParams := ThreadListFrame1.ThreadListParams;
	IniFile.TreeViewWidth := BoardView.Width;
	IniFile.MainFormRect := Rect(Left, Top, Width, Height);
	IniFile.WindowState := WindowState;
	IniFile.BodyStyle := ThreadView.BodyStyle;
	IniFile.ThreadListParams := ThreadListFrame1.ThreadListParams;
	IniFile.ShowToolBar := ViewShowToolBar.Checked;

	{ INIt@C̓ǂݏ }
	IniFile.Update(Direction);

	{ lݒ }
	ThreadListFrame1.ThreadListParams := IniFile.ThreadListParams;
	ThreadListFrame1.IniFileUpdate(IniFile, True);
	BoardView.Width := IniFile.TreeViewWidth;
	Top := IniFile.MainFormRect.Top;
	Left := IniFile.MainFormRect.Left;
	Width := IniFile.MainFormRect.Right;
	Height := IniFile.MainFormRect.Bottom;
	WindowState := IniFile.WindowState;
	ThreadView.BodyStyle := IniFile.BodyStyle;
	ViewShowToolBar.Checked := IniFile.ShowToolBar;
	KatfavUtilsDefaultBrowser := IniFile.DefaultBrowserCommand;

	with TKatjusha.GetCommParams do
	begin
		ProxyParams.Clear;
		ProxyParams.ProxyPort := IniFile.ProxyPort;
		ProxyParams.ProxyServer := IniFile.ProxyAddress;
		ReadTimeOut := IniFile.TimeOut * 1000;
	end;
end;

procedure TKatfavMainForm.FileArchiveExecute(Sender: TObject);
begin
	if BoardView.Selected = nil then Exit;

	ThreadArchiveDlg.ArchiveExt := IniFile.ArchiveExt;
	ThreadArchiveDlg.IndexList := BoardView.Selected;

	if ThreadArchiveDlg.ShowModal = mrOk then
		if ThreadArchiveDlg.DeleteLib then
		begin
			{ 폜ꍇ̓c[̕폜 }
			BoardView.FavTreeView.Items.Delete(BoardView.FavTreeView.Selected);
			ThreadListFrame1.Selected := nil;		{ Xg̕\NA }	
		end;
end;

procedure TKatfavMainForm.ToolOptionExecute(Sender: TObject);
begin
	OptionDlg.KatfavIniFile := IniFile;
	IniFile.ThreadListParams := ThreadListFrame1.ThreadListParams;
	if OptionDlg.ShowModal = mrOk then
	begin
		with TKatjusha.GetCommParams do
		begin
			ProxyParams.Clear;
			ProxyParams.ProxyPort := IniFile.ProxyPort;
			ProxyParams.ProxyServer := IniFile.ProxyAddress;
			ReadTimeOut := IniFile.TimeOut * 1000;
		end;
		ThreadListFrame1.ThreadListParams := IniFile.ThreadListParams;
		KatfavUtilsDefaultBrowser := IniFile.DefaultBrowserCommand;
	end;
end;

procedure TKatfavMainForm.EditSortTitleMenuItemClick(Sender: TObject);
begin
	ThreadListFrame1.Sort(tsTitle);
end;

procedure TKatfavMainForm.EditSortThreadNumMenuItemClick(Sender: TObject);
begin
	ThreadListFrame1.Sort(tsThreadNum);
end;

procedure TKatfavMainForm.EditSortLevelMenuItemClick(Sender: TObject);
begin
	ThreadListFrame1.Sort(tsGravity);
end;

procedure TKatfavMainForm.EditSortBoardMenuItemClick(Sender: TObject);
begin
	ThreadListFrame1.Sort(tsBoardName);
end;

procedure TKatfavMainForm.EditSortMemoMenuItemClick(Sender: TObject);
begin
	ThreadListFrame1.Sort(tsMemo);
end;

procedure TKatfavMainForm.ThreadListFrame1ListViewDblClick(Sender: TObject);
begin
	if ThreadListFrame1.SelectedIndex = nil then Exit;

	case ThreadListFrame1.ThreadListParams.DblClickAction of
		daInternal: ViewShowBrowserView.Execute;
		daProperty: ThreadListFrame1.ShowProperty(IniFile);
		else ThreadListFrame1.ListViewDblClick(Sender);
	end;
end;

procedure TKatfavMainForm.ThreadCatchError(const Msg: string);
begin
	ShowMessage(Msg);
end;

procedure TKatfavMainForm.ThreadListFrame1FilePropertyExecute(Sender: TObject);
var
	ThreadIdx: T2chThreadIndex;
begin
//  ThreadListFrame1.FilePropertyExecute(Sender);
	if ThreadListFrame1.ShowProperty(IniFile) then
	begin
		{ vpeBłnj{^ꂽꍇ͒ɕۑ }
		ThreadIdx := ThreadListFrame1.SelectedIndex;
		if ThreadIdx.Modified then	{ ۂɒlύXꂽƂ̂ݕۑ }
		begin
			ThreadIdx.SaveToFile(TKatjusha.GetKatjushaBaseDir + 'log\' + ThreadIdx.LogPath);
			ThreadListFrame1.RefreshItem(ThreadListFrame1.ListView.Selected);
		end;
	end;
end;

procedure TKatfavMainForm.ViewShowBrowserViewExecute(Sender: TObject);
begin
	if ThreadListFrame1.SelectedIndex <> nil then
	begin
		if not BrowserView.Visible then
		begin
			{ uEUr[߂ĕ\ƂɃTCY̐ݒs }
			if not BrowserViewShowFirst then
			begin
				BrowserView.Height := RightPanel.ClientHeight div 2;
				BrowserViewShowFirst := True;
			end;
			BrowserView.Visible := True;
			Splitter2.Visible := True;
		end;
		BrowserView.ThreadIdx := ThreadListFrame1.SelectedIndex;
	end;
end;

procedure TKatfavMainForm.BoardViewFavTreeViewClick(Sender: TObject);
begin
	with BoardView do
	begin
		if FavTreeView.Selected = nil then Exit;
		if FavTreeView.Selected.Data = nil then Exit;

		ThreadListFrame1.Selected := T2chIndexList(FavTreeView.Selected.Data);
	end;
end;

procedure TKatfavMainForm.BoardViewFavTreeViewDragDrop(Sender, Source: TObject;
  X, Y: Integer);
var
	TreeNode: TTreeNode;
	IndexList: T2chIndexList;
begin
	TreeNode := BoardView.FavTreeView.GetNodeAt(X, Y);
	if TreeNode = nil then Exit;
	IndexList := T2chIndexList(TreeNode.Data);
	ThreadListFrame1.Cut(IndexList);
end;

procedure TKatfavMainForm.BrowserViewCloseButtonClick(Sender: TObject);
begin
	BrowserView.Visible := False;
	Splitter2.Visible := False;
end;

procedure TKatfavMainForm.ToolGetResStatusExecute(Sender: TObject);
begin
	if (ThreadListFrame1.SelectedBoard <> '') and (Pos('jbbs.shitaraba.com', ThreadListFrame1.SelectedBoard) = 0) then
		ToolGetResStatusSubject.Execute
	else begin
		Assert(ResCheckThread.Suspended);
		ResCheckThread.Params := IniFile.NewResCheckParams;
		ResCheckThread.DisplayName := ThreadListFrame1.Selected.DisplayName;
		ResCheckThread.Resume;
		ResCheckTimer.Enabled := True;
		BoardView.Enabled := False;
	end;
end;

procedure TKatfavMainForm.ResCheckTimerTimer(Sender: TObject);
begin
	ResCheckTimer.Enabled := False;
end;

procedure TKatfavMainForm.EditSortCheckResMenuItemClick(Sender: TObject);
begin
	ThreadListFrame1.Sort(tsCheckRes);
end;

procedure TKatfavMainForm.BoardViewBoardTreeViewClick(Sender: TObject);
var
	Subject: T2chSubject;
	FileName, Status: string;
	Date: TDateTime;
	AYear, AMonth, ADay, AHour, AMinute, ASecond, AMilliSecond: Word;
	Loaded: Boolean;
begin
//  BoardView.BoardTreeViewClick(Sender);
	Subject := nil;
	Loaded := True;
	
	if BoardView.SelectedBoard <> '' then
	begin
		try
			if IniFile.ThreadListParams.UseNewThreadReport and
					IniFile.NewResCheckParams.UseSavedSubject then
			begin
				Subject := T2chSubject.Create;
				FileName := TKatjusha.GetKatjushaBaseDir + 'subject\' + URLToPath(BoardView.SelectedBoard) + '.txt';

				try
					Subject.LoadFromFile(FileName);
				except
					on EFOpenError do begin
						StatusText := 'V`FbN͂܂sĂ܂B';
						Loaded := False;
					end;
					else
						Raise;
				end;

				if Loaded then
				begin
					Date := Now - Subject.ContentDate;
					DecodeDateTime(Date, AYear, AMonth, ADay, AHour, AMinute, ASecond, AMilliSecond);
					ADay := DaysBetween(Now, Subject.ContentDate);
					if ADay <> 0 then Status := Status + IntToStr(ADay) + '';
					if AHour <> 0 then Status := Status + IntToStr(AHour) + '';
					Status := Format('O̐V`FbN%s%d%dbo߂܂B', [Status, AMinute, ASecond]);
					StatusText := Status;
				end else
					FreeAndNil(Subject);

				{ łɓǂݍłꍇ͎gpȂ }
				if BoardView.SelectedBoardParams.SubjectLoaded then
					FreeAndNil(Subject);

				BoardView.SelectedBoardParams.SubjectLoaded := True;
			end;

			ThreadListFrame1.CreateAlreadyGetList(BoardView.SelectedBoard, Subject);
		finally
			Subject.Free;
		end;
	end;
end;

procedure TKatfavMainForm.ToolGetResStatusSubjectExecute(Sender: TObject);
var
	Subject, FreshList: T2chSubject;
	SubjectIniFile: T2chSubjectIniFile;
	IndexList: T2chIndexList;
	I, J, Count: Integer;
	URL, FileName: string;
	ThreadIdx: T2chThreadIndex;
	NewThreadCheck, UpdateIndex: Boolean;
	OrigCursor: TCursor;
begin
	if BoardView.SelectedBoard = '' then Exit;

	OrigCursor := Screen.Cursor;
	Subject := nil;
	SubjectIniFile := nil;
	ThreadIdx := nil;
	FreshList := nil;
	IndexList := ThreadListFrame1.Selected;
	NewThreadCheck := True;

	UpdateIndex := False;
	if IniFile.NewResCheckParams.UpdateIndexFile then
		if not IniFile.NewResCheckParams.NoUpdateRunningKatjusha then
			UpdateIndex := True
		else if FindKatjushaForm = 0 then
			UpdateIndex := True;

	URL := 'http://' + BoardView.SelectedBoard + '/subject.txt';
	FileName := TKatjusha.GetKatjushaBaseDir + 'subject\' + URLToPath(BoardView.SelectedBoard) + '.txt';

	try
		{ J[\ύX }
		OrigCursor := Screen.Cursor;
		Screen.Cursor := crHourGlass;
		
		Subject := T2chSubject.Create;
		SubjectIniFile := T2chSubjectIniFile.Create;
		FreshList := T2chSubject.Create;
		ThreadIdx := T2chThreadIndex.Create;

		{ Subject.init@Cǂݍ }
		try
			SubjectIniFile.LoadFromFile(ChangeFileExt(FileName, '.ini'));
		except
			on EFOpenError do
				SubjectIniFile.Clear;
			else
				raise;
		end;

		{ ۑĂÂsubject.txtǂݍ }
		if ThreadListFrame1.ThreadListParams.UseNewThreadReport then
		begin
			try
				FreshList.LoadFromFile(FileName);
			except
				on E: EFOpenError do
					NewThreadCheck := False; { t@CJȂƂ̓`FbNȂ }
				on E: E2chSubjectError do
					NewThreadCheck := False; { XMLt@CɃG[Ƃ`FbNȂ }
				else
					raise;
			end;
		end else
			NewThreadCheck := False;

		StatusText := URL + 'ǂݍݒc';
		try
			Subject.LoadFromURL(URL, SubjectIniFile);
		except
			on E: EIdHTTPProtocolException do
				if E.ReplyErrorCode = 304 then	{ Not Modified }
				begin
					StatusText := URL + '̓ǂݍ݊(XVȂ)';
					Exit;
				end else begin
					StatusText := 'ʐMG[: ' + E.Message;
					Abort;
				end;
			on E: EIdException do begin
				StatusText := 'ʐMG[: ' + E.Message;
				Abort;
			end;
			else
				raise;
		end;

		{ Subject.init@C̕ۑ }
		SubjectIniFile.SaveToFile(ChangeFileExt(FileName, '.ini'));

		if ThreadListFrame1.ThreadListParams.UseNewThreadReport then
		begin
			ForceDirectories(TKatjusha.GetKatjushaBaseDir + 'subject');
			Subject.SaveToFile(FileName);
		end;
		{ subject.txtǂݍ݃tOTrueɂ }
		BoardView.SelectedBoardParams.SubjectLoaded := True;
		StatusText := URL + '̓ǂݍ݊(X:' + IntToStr(Subject.Count) + ')';

    { VX`FbN }
		if NewThreadCheck then
		begin
			Count := FreshList.Diff(FreshList, Subject);
			if Count > 0 then
			begin
				StatusText := Format('%s̓ǂݍ݊(X:%d,VX:%d)', [URL, Subject.Count, Count]);
				{ VKXt[\ }
				NewThreadView.CreateList(BoardView.SelectedBoard, FreshList);
				if not ViewShowNewThreadView.Checked then
					ViewShowNewThreadView.Execute;
				NewThreadView.RefreshColumn;
			end;
		end;

		for I := 0 to IndexList.Count - 1 do
		begin
			IndexList[I].Depth := 0; { [x0ɏĂ }
			
			J := Subject.IndexOf(IndexList[I].ThreadNum);
			if J >= 0 then
			begin
				ThreadIdx.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + IndexList[I].LogPath);
				ThreadIdx.BeforeResCount := Subject.ResCount[J];
				IndexList[I].Depth := Subject.Depth[J];
				{ VXۑ }
				if UpdateIndex and ThreadIdx.Modified then
					ThreadIdx.SaveToFile(TKatjusha.GetKatjushaBaseDir + 'log\' + IndexList[I].LogPath);
				IndexList[I].ResCount := ThreadIdx.ResCount;
				IndexList[I].BeforeResCount := Subject.ResCount[J];
				if IndexList[I].ResCount < Subject.ResCount[J] then
					IndexList[I].ResState := rsNew
				else if IndexList[I].ResCount > Subject.ResCount[J] then
					IndexList[I].ResState := rsError { Subject傫Γd擾̋^̂ŃG[ɂ }
				else if (IndexList[I].ResCount = Subject.ResCount[J]) and (IndexList[I].ResState = rsNew) then
					IndexList[I].ResState := rsNone;	{ ̂Ƃ͐VtO͂ }
			end;
		end;

		IndexList.BoardSort([tsCheckRes, tsAsc], []);
		ThreadListFrame1.RefreshView;
	finally
		Screen.Cursor := OrigCursor;
		
		ThreadIdx.Free;
		FreshList.Free;
		SubjectIniFile.Free;
		Subject.Free;
	end;
end;

procedure TKatfavMainForm.SetStatusText(const Value: string);
begin
	StatusBar.Panels.Items[1].Text := Value;
	Application.ProcessMessages;
end;

procedure TKatfavMainForm.StatusBarResize(Sender: TObject);
begin
	StatusBar.Panels.Items[1].Width := StatusBar.ClientWidth - 150 - 100;
end;

procedure TKatfavMainForm.SetCurrentBoard(const Value: string);
begin
	StatusBar.Panels[2].Text := Value;
	Application.ProcessMessages;
end;

procedure TKatfavMainForm.ThreadListFrame1FileSelectBoardExecute(
  Sender: TObject);
begin
	if ThreadListFrame1.Selected = nil
		then CurrentBoard := ''
		else CurrentBoard := ThreadListFrame1.Selected.DisplayName;
end;

procedure TKatfavMainForm.EditCustomSortExecute(Sender: TObject);
begin
	if TCustomSortListDlg.Execute(CustomSortList) then
		RefreshCustomSortMenu;
end;

procedure TKatfavMainForm.ViewShowNewThreadViewUpdate(Sender: TObject);
begin
	ViewShowNewThreadView.Checked := NewThreadView.Visible;
end;

procedure TKatfavMainForm.ToolGetResStatusUpdate(Sender: TObject);
begin
	{ V`FbN̓^C}[쓮͖ɂ }
	if ThreadListFrame1.SelectedBoard = '' then
		(Sender as TAction).Enabled := not ResCheckTimer.Enabled
	else if Pos('jbbs.shitaraba.com', ThreadListFrame1.SelectedBoard) > 0 then
		(Sender as TAction).Enabled := not ResCheckTimer.Enabled
	else
		(Sender as TAction).Enabled := True;
end;

procedure TKatfavMainForm.ViewShowNewThreadViewExecute(Sender: TObject);
begin
	if ViewShowNewThreadView.Checked then
	begin
		NewThreadView.Visible := True;
		Splitter3.Visible := True;
	end else begin
		Splitter3.Visible := False;
		NewThreadView.Visible := False;
	end;
end;

procedure TKatfavMainForm.NewThreadViewCloseButtonClick(Sender: TObject);
begin
	ViewShowNewThreadView.Execute;
end;

procedure TKatfavMainForm.FileActionUpdate(Sender: TObject);
begin
	{ オNĂԂׂ͂ĕۑ𖳌ɂ }
	(Sender as TAction).Enabled := (not NowLoading) and (FindKatjushaForm = 0);
end;

procedure TKatfavMainForm.ToolSortLibUpdate(Sender: TObject);
begin
	(Sender as TAction).Enabled := (not NowLoading);
end;

procedure TKatfavMainForm.ThreadListFrame1EditMoveSelServerExecute(
  Sender: TObject);
begin
	if ThreadListFrame1.SelectedIndex = nil then Exit;

	with ThreadListFrame1.SelectedIndex do
		BoardView.SelectedBoard := ServerName + '/' + BoardPath;
end;

procedure TKatfavMainForm.ThreadListFrame1EditDeleteLogExecute(
	Sender: TObject);
var
	IndexList: T2chIndexList;
	I, J: Integer;
	DelList: TStringList;
	Msg: string;
	ObjList: TObjectList;
	Item: TTreeNode;
	procedure DeleteFromList(List: T2chIndexList; ThreadIdx: T2chThreadIndex);
	var
		Index: Integer;
	begin
		Index := List.IndexOf(ThreadIdx);
		if Index >= 0 then
			List.Delete(Index);
	end;
begin
	IndexList := nil;
	DelList := nil;
	ObjList := nil;
	
	try
		IndexList := T2chIndexList.Create(False);
		DelList := TStringList.Create;
		ObjList := TObjectList.Create(False);

		Item := BoardView.FavTreeView.Items.GetFirstNode;
		while Item <> nil do
		begin
			if Item.Data <> nil then
				ObjList.Add(T2chIndexList(Item.Data));
			Item := Item.GetNext;
		end;
		ObjList.Add(ThreadListFrame1.Selected);

		if ThreadListFrame1.CreateSelectedThreadList(IndexList) <= 0 then Exit;

		if IndexList.Count = 1
			then Msg := '"' + IndexList[0].ThreadName + '"' + '폜Ă낵łH'
			else Msg := Format('%d̃Xbh폜Ă낵łH', [IndexList.Count]);

		if MessageDlg(Msg, mtWarning, mbOKCancel, 0) <> mrOk then Exit;

		for I := 0 to IndexList.Count - 1 do
		begin
			for J := 0 to ObjList.Count - 1 do
				DeleteFromList(T2chIndexList(ObjList[J]), IndexList[I]);

			J := DelList.Add(TKatjusha.GetKatjushaBaseDir + 'log\' + IndexList[I].LogPath);
			DelList.Add(ChangeFileExt(DelList[J], '.dat'));

			{  }
			DeleteFromList(FMasterIndex, IndexList[I]);
		end;

		MoveToRecycleBin(DelList);

		ThreadListFrame1.RefreshView;
	finally
		ObjList.Free;
		DelList.Free;
		IndexList.Free;
	end;
end;

constructor TKatfavMainForm.Create(AOwner: TComponent);
begin
	FKatjusha := TKatjusha.Create;
	FMasterIndex := T2chIndexList.Create(True);

	inherited;
end;

destructor TKatfavMainForm.Destroy;
begin
	inherited;

	FreeAndNil(FMasterIndex);
	FreeAndNil(FKatjusha);
end;

procedure TKatfavMainForm.RefreshCustomSortMenu;
var
	I: Integer;
	Item: TMenuItem;
begin
	for I := EditSortMenuItem.Count - 1 downto CustomSortSepMenuItem.MenuIndex + 1 do
	begin
		Item := EditSortMenuItem[I];
		EditSortMenuItem.Delete(I);
		FreeAndNil(Item);
	end;

	if CustomSortList.Count = 0 then
	begin
		CustomSortSepMenuItem.Visible := False;
		Exit;
	end;

	for I := 0 to CustomSortList.Count - 1 do
	begin
		Item := NewItem(CustomSortList.Names[I], 0, false, true, CustomSortMenuClick, 0, 'CustomSort' + IntToStr(I));
		Item.Tag := I;
		EditSortMenuItem.Add(Item);
	end;

	CustomSortSepMenuItem.Visible := True;
end;

procedure TKatfavMainForm.CustomSortMenuClick(Sender: TObject);
var
	I: Integer;
	List: T2chCustomSortList;
begin
	List := CustomSortList[(Sender as TMenuItem).Tag];
	for I := 0 to List.Count - 1 do
		ThreadListFrame1.Selected.BoardSort(List[I], []);
	ThreadListFrame1.RefreshView;
end;

procedure TKatfavMainForm.ViewShowToolBarExecute(Sender: TObject);
begin
	CoolBar.Visible := ViewShowToolBar.Checked;
end;

procedure TKatfavMainForm.ToolKickKatjushaExecute(Sender: TObject);
var
	KatjushaHandle: HWND;
begin
	KatjushaHandle := FindKatjushaForm;
	if KatjushaHandle <> 0 then
	begin
		SendMessage(KatjushaHandle, WM_CLOSE, 0, 0);
		TRestartKatjusha.Execute;
	end;
	
	CallKatjusha('');
end;

procedure TKatfavMainForm.ToolKickKatjushaUpdate(Sender: TObject);
begin
	{ [h͍ċNȂ }
	(Sender as TAction).Enabled := not NowLoading;
end;

procedure TKatfavMainForm.FlagNormalActionExecute(Sender: TObject);
begin
	if ThreadListFrame1.SelectedIndex = nil then Exit;
	ThreadListFrame1.SetThreadState(stNormal);
	if ThreadListFrame1.SelCount > 1
		then ThreadListFrame1.RefreshView
		else ThreadListFrame1.RefreshItem(ThreadListFrame1.ListView.Selected);
end;

procedure TKatfavMainForm.FlagDatDropActionExecute(Sender: TObject);
begin
	if ThreadListFrame1.SelectedIndex = nil then Exit;
	ThreadListFrame1.SetThreadState(stLog);
	if ThreadListFrame1.SelCount > 1
		then ThreadListFrame1.RefreshView
		else ThreadListFrame1.RefreshItem(ThreadListFrame1.ListView.Selected);
end;

procedure TKatfavMainForm.FlagFavoriteActionExecute(Sender: TObject);
begin
	if ThreadListFrame1.SelectedIndex = nil then Exit;
	ThreadListFrame1.SetThreadState(stFavorite);
	if ThreadListFrame1.SelCount > 1
		then ThreadListFrame1.RefreshView
		else ThreadListFrame1.RefreshItem(ThreadListFrame1.ListView.Selected);
end;

procedure TKatfavMainForm.ToolAllThreadListCreateExecute(Sender: TObject);
begin
	if TAllThreadSearchForm.Execute(FMasterIndex, BoardView.AllThreadNode) then
	begin
		BoardView.FavTreeView.Selected := BoardView.AllThreadNode;
		ThreadListFrame1.Selected := T2chIndexList(BoardView.AllThreadNode.Data);
		BoardView.ChangeFavoritesTab; { Cɓ^uɐ؂ւ }
	end;
end;

procedure TKatfavMainForm.FileReloadThreadLibsExecute(Sender: TObject);
begin
	{ [UɊmF }
	if MessageDlg('Xbhqɂ̍Ď擾ȂƂ܂ł̕ύXɂȂ܂낵łH', mtWarning, mbOkCancel, 0) = mrCancel then
		Exit;
		
	{ XXgNA }
	ThreadListFrame1.Selected := nil;

	{ {[hr[̑֎~ }
	BoardView.ChangeFavoritesTab; { Cɓ^uɐ؂ւ }
	BoardView.RootNode.Selected := True; { u[vI }
	BoardView.Enabled := False;

	{ SCɓ̍폜 }
	BoardView.RemoveAllFavorites;
	{ BoardViewParams̃NA }
	BoardView.ClearViewParams;

	{ Nbv{[h̏ }
	if Assigned(BoardView.ClipBoardNode.Data) then
		with BoardView.ClipBoardNode do
			T2chIndexList(Data).Clear;

	{ MasterIndex }
	FMasterIndex.Clear;

	{ {[hr[̑ }
	BoardView.Enabled := True;
	
	{ CɓꗗĎ擾 }
	FavoriteList.Clear;
	FKatjusha.GetFavoriteList(FavoriteList, False);
	FavoriteList.Sort;
	FavoriteList.Insert(0, 'favorite');
	ReflectNoLoadFavorites(FavoriteList, IniFile.NoLoadFavoritesDetail);

	{ Xbh쐬 }
	LibLoadThread := TLibLoadThread.Create(True);
	LibLoadThread.FavoriteList.Assign(FavoriteList);

	{ ߋOqɓǂݍ݃Xbhs }
	NowLoading := True;
	LibLoadThread.Resume;
end;

procedure TKatfavMainForm.FileArchiveUpdate(Sender: TObject);
begin
	(Sender as TAction).Enabled := (BoardView.Selected <> nil);
end;

procedure TKatfavMainForm.BoardViewFavPopupMenuPopup(Sender: TObject);
begin
	ThreadListFrame1.Selected := BoardView.Selected;
	{ Ȃłł܂̂s }
	BoardView.FavTreeView.Selected := BoardView.FavTreeView.Selected;
end;

procedure TKatfavMainForm.AddBoardButton(ButtonType: TBoardButtonType;
	BoardName, BoardURL: string);
begin
	{ {^̒ǉ }
	FBoardButtonManager.Add(ButtonType, BoardName, BoardURL);
end;

function TKatfavMainForm.BoardToolButtonToPath(
	Button: TToolButton): string;
var
	Board: string;
	BoardList: array [0 .. 1] of string;
begin
	Result := '';

	if Button.Tag <= 0 then Exit;
	Board := FBoardButtonManager.Buttons[Button.Tag - 1];

	if Pos('Favorites:', Board) <> 1 then
	begin
		{ {[h }
		AWKSplit('<>', Board, BoardList);
		Result := BoardList[1];
	end;
end;

function TKatfavMainForm.BoardToolButtonToURL(Button: TToolButton): string;
var
	BoardPath, ServerName, BoardName: string;
begin
	Result := '';
	BoardPath := BoardToolButtonToPath(Button);

		AWKMatch1('^([^/]+)/', BoardPath, ServerName);
		AWKMatch1('^[^/]+/(.+)$', BoardPath, BoardName);

	if BoardPath <> '' then
		Result := FKatjusha.GetBoardUrl(ServerName, BoardName);
end;

procedure TKatfavMainForm.BoardButtonClick(Sender: TObject);
var
	Board: string;
	I: Integer;
	Node: TTreeNode;
	BoardList: TStringList;
begin
	if (Sender as TToolButton).Tag <= 0 then Exit;
	Board := FBoardButtonManager.Buttons[(Sender as TToolButton).Tag - 1];
	BoardList := nil;

	try
		BoardList := TStringList.Create;

		if Pos('Favorites:', Board) = 1 then
		begin
			{ Cɓ }
			Board := StringReplace(Board, 'Favorites:', '', []);
			with BoardView do
				for I := 0 to RootNode.Count - 1 do
				begin
					Node := RootNode[I];
					if Node.Text = Board then
					begin
						ChangeFavoritesTab;
						Node.Selected := True;
						Node.MakeVisible;
						ThreadListFrame1.Selected := T2chIndexList(Node.Data);
						Break;
					end;
				end;
		end else begin
			{ {[h }
			AWKSplit('<>', Board, BoardList);
			BoardView.SelectedBoard := BoardList[1];
		end;
	finally
		BoardList.Free;
	end;
end;

function TKatfavMainForm.ComponentToBoardToolButton(
	AComponent: TComponent): TToolButton;
var
	I: Integer;
	Button: TToolButton;
begin
	Button := nil;

	for I := 0 to BoardToolBar.ButtonCount - 1 do
		if BoardToolButtonPopupMenu.PopupComponent = BoardToolBar.Buttons[I] then
		begin
			Button := BoardToolBar.Buttons[I];
			Break;
		end;

	Assert(Button <> nil);

	Result := Button;
end;

procedure TKatfavMainForm.BoardToolButtonPopupMenuPopup(Sender: TObject);
var
	Button: TToolButton;
	Flag: Boolean;
begin
	Button := ComponentToBoardToolButton(BoardToolButtonPopupMenu.PopupComponent);
	Flag := BoardToolButtonToPath(Button) <> '';

	BoardToolButtonBrowerOpenMenuItem.Enabled := Flag;
	BoardToolButtonThreadListOpenMenuItem.Enabled := Flag;
	BoardToolButtonURLCopyMenuItem.Enabled := Flag;
end;

procedure TKatfavMainForm.BoardToolButtonBrowerOpenMenuItemClick(
	Sender: TObject);
var
	Button: TToolButton;
	URL: string;
begin
	Button := ComponentToBoardToolButton(BoardToolButtonPopupMenu.PopupComponent);
	URL := BoardToolButtonToURL(Button);

	if URL <> '' then
		CallBrowser(URL);
end;

procedure TKatfavMainForm.BoardToolButtonThreadListOpenMenuItemClick(
  Sender: TObject);
var
	ThreadListForm: TThreadListForm;
	Button: TToolButton;
	BoardPath: string;
begin
	Button := ComponentToBoardToolButton(BoardToolButtonPopupMenu.PopupComponent);
	BoardPath := BoardToolButtonToPath(Button);

	if BoardPath = '' then Exit;
	
	ThreadListForm := TThreadListForm.Create(Application);
	try
		ThreadListForm.BoardPath := BoardPath;
		ThreadListForm.Caption := Button.Caption + ThreadListForm.Caption;
		ThreadListForm.Show;
		ThreadListForm.NewThreadView.RefreshColumn;
	except
		ThreadListForm.Release;
		Raise;
	end;
end;

procedure TKatfavMainForm.BoardToolButtonURLCopyMenuItemClick(
	Sender: TObject);
var
	Button: TToolButton;
	URL: string;
begin
	Button := ComponentToBoardToolButton(BoardToolButtonPopupMenu.PopupComponent);
	URL := BoardToolButtonToURL(Button);

	if URL <> '' then
		Clipbrd.Clipboard.AsText := URL;
end;

procedure TKatfavMainForm.BoardToolButtonDeleteMenuItemClick(
	Sender: TObject);
var
	Button: TToolButton;
begin
	Button := ComponentToBoardToolButton(BoardToolButtonPopupMenu.PopupComponent);

{	Index := Button.Tag;
	FBoardButtonList.Delete(Index);	폜IndexĂ܂̂ōsȂ }
	RemoveToolButton(BoardToolBar, Button);
end;

procedure TKatfavMainForm.BoardToolButtonCustomizeMenuItemClick(
	Sender: TObject);
begin
	BoardToolBar.Perform(TB_CUSTOMIZE, 0, 0);
end;

procedure TKatfavMainForm.ReflectNoLoadFavorites(FavList,
	NoLoadList: TStringList);
var
	I, Idx: Integer;
begin
	for I := 0 to NoLoadList.Count - 1 do
	begin
		Idx := FavList.IndexOf(NoLoadList[I]);
		if Idx >= 0 then FavList.Delete(Idx);
	end;
end;

procedure TKatfavMainForm.AddSubForm(AForm: TForm);
begin
	if FWindowList <> nil then
		FWindowList.Add(AForm);
end;

procedure TKatfavMainForm.RemoveSubForm(AForm: TForm);
begin
	if FWindowList <> nil then
		FWindowList.Remove(AForm);
end;

procedure TKatfavMainForm.Window1Click(Sender: TObject);
begin
	FWindowList.Refresh;
end;

procedure TKatfavMainForm.WindowCloseAllExecute(Sender: TObject);
begin
	FWindowList.CloseAll;
end;

procedure TKatfavMainForm.Refresh(Index: T2chThreadIndex);
begin
	ThreadListFrame1.RefreshItem(Index);
end;

procedure TKatfavMainForm.HelpOpenHomepageExecute(Sender: TObject);
begin
  CallBrowser(KATFAV_HOMEPAGE_URL);
end;

procedure TKatfavMainForm.FormCloseQuery(Sender: TObject;
	var CanClose: Boolean);
var
	I, Button: Integer;
	Item: TTreeNode;
	Index: T2chIndexList;
	Modified: Boolean;
begin
	{ ۑmFL̏ꍇ }
	if IniFile.SaveConfirmation then
	begin
		CanClose := True;
		Modified := False;

		with BoardView do
			for I := 0 to RootNode.Count - 1 do
			begin
				Item := RootNode.Item[I];
				if Item.Data = nil then Continue;

				Index := T2chIndexList(Item.Data);
        Modified := Modified or Index.Modified;
			end;

		if Modified then
		begin
			if FileSaveAll.Enabled then
			begin
				Button := MessageDlg('XbhqɂύXĂ܂Bׂĕۑ܂H',
														 mtConfirmation, mbYesNoCancel, 0);
				case Button of
					mrYes: SaveAll;
					mrCancel: CanClose := False;
				end;
			end else if MessageDlg('XbhqɂύXĂ܂AׂĕۑɂȂĂĕۑł܂B'#13#10 +
						'I܂H', mtConfirmation, [mbYes, mbNo], 0) = mrNo then
					CanClose := False;
		end;
	end;
end;

procedure TKatfavMainForm.SaveAll;
var
	I, J: Integer;
	Item: TTreeNode;
	Index: T2chIndexList;
{ LoadThreadDatSizeAndResCount }
	procedure LoadThreadDatSizeAndResCount(Index: T2chIndexList);
	var
		I: Integer;
		ThreadIdx: T2chThreadIndex;
	begin
		ThreadIdx := T2chThreadIndex.Create;
		try
			for I := 0 to Index.Count - 1 do
			begin
				try
					ThreadIdx.LoadFromFile(TKatjusha.GetKatjushaBaseDir + 'log\' + Index[I].LogPath);
				except
					on EFOpenError do
						Continue;
				end;
				Index[I].DatSize := ThreadIdx.DatSize;
				Index[I].ResCount := ThreadIdx.ResCount;
			end;
		finally
			ThreadIdx.Free;
		end;
	end;
begin
	with BoardView do
		for I := 0 to RootNode.Count - 1 do
		begin
			Item := RootNode.Item[I];
			if Item.Data = nil then Continue;
			Index := T2chIndexList(Item.Data);

			if Index.LibName = 'favorite' then
				for J := 0 to Index.Count - 1 do
					Index[J].InFavorite := True
			else
				for J := 0 to Index.Count - 1 do
					if (not Index[J].InFavorite) and (stFavorite in Index[J].State) then
						Index[J].State := Index[J].State - [stFavorite];

      LoadThreadDatSizeAndResCount(Index);

			if Index.LibName <> '' then
				Index.SaveToFile(Index.LibName + '.idx')
			else
				Index.SaveToFile(Item.Text + '.idx');
		end;
end;

procedure TKatfavMainForm.FormDeactivate(Sender: TObject);
begin
	if Assigned(Application.OnDeactivate) then
		Application.OnDeactivate(Application);
end;

procedure TKatfavMainForm.ToolFullTextSearchExecute(Sender: TObject);
var
	IndexList: T2chIndexList;
	FullTextSearchForm: TFullTextSearchForm;
begin
	IndexList := nil;
	FullTextSearchForm := nil;

	FFullTextSearchConfig.TargetThread := fttAll;
	if ThreadListFrame1.SelectedIndex <> nil
		then FFullTextSearchConfig.TargetThread := fttSelected
		else FFullTextSearchConfig.TargetThread := fttFixed;

	if not TFullTextSearchConfigDlg.Execute(Self, FFullTextSearchConfig) then Exit;
	try
		FullTextSearchForm := TFullTextSearchForm.Create(Application);

		if FFullTextSearchConfig.TargetThread in [fttAll, fttFixed] then
		begin
			if ThreadListFrame1.Selected <> nil then
				FullTextSearchForm.StartSearch(ThreadListFrame1.Selected, FFullTextSearchConfig);
		end else
		begin
			try
				IndexList := ThreadListFrame1.GetSelectedIndexs;
				if IndexList <> nil then
					FullTextSearchForm.StartSearch(IndexList, FFullTextSearchConfig);
			finally
				IndexList.Free;
			end;
		end;
	except
		FullTextSearchForm.Release;
		raise;
	end;
end;

initialization
	OleInitialize(nil);

finalization
	OleUninitialize;

end.

