unit ThLibSort;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons;

type
  TThreadLibSortDlg = class(TForm)
    ListBox: TListBox;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    UpBtn: TBitBtn;
    DownBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure UpBtnClick(Sender: TObject);
    procedure DownBtnClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ListBoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ListBoxDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
  private
		{ Private 錾 }
		ThreadLibraryList: TStringList;
		DragThreadIndex: Integer;
  public
		{ Public 錾 }
		class function Execute(ThreadLib: TStringList): Boolean;
	end;

implementation

{$R *.dfm}

{ TThreadLibSortDlg }

class function TThreadLibSortDlg.Execute(ThreadLib: TStringList): Boolean;
var
	ThreadLibSortDlg: TThreadLibSortDlg;
begin
	ThreadLibSortDlg := TThreadLibSortDlg.Create(Application.MainForm);
	try
		ThreadLibSortDlg.ThreadLibraryList.Assign(ThreadLib);
		Result := IsPositiveResult(ThreadLibSortDlg.ShowModal);
	finally
		ThreadLibSortDlg.Free;
	end;
end;

procedure TThreadLibSortDlg.FormCreate(Sender: TObject);
begin
	ThreadLibraryList := TStringList.Create;
end;

procedure TThreadLibSortDlg.FormDestroy(Sender: TObject);
begin
	FreeAndNil(ThreadLibraryList);
end;

procedure TThreadLibSortDlg.FormActivate(Sender: TObject);
begin
	{ Cɓ͍ŏ㕔ɌŒ肳Ă̂ł͂ }
	ThreadLibraryList.Delete(ThreadLibraryList.IndexOf('favorite'));
	ListBox.Items.Assign(ThreadLibraryList);
end;

procedure TThreadLibSortDlg.UpBtnClick(Sender: TObject);
var
	Index: Integer;
begin
	if ListBox.ItemIndex <= 0 then Exit;
	with ListBox do
	begin
		Index := ItemIndex;
		Items.BeginUpdate;
		Items.Insert(Index - 1, Items[Index]);
		Items.Delete(Index + 1);
		Items.EndUpdate;
		ItemIndex := Index - 1;
	end;
	ListBox.SetFocus;
end;

procedure TThreadLibSortDlg.DownBtnClick(Sender: TObject);
var
	Index: Integer;
begin
	if (ListBox.ItemIndex < 0) or (ListBox.ItemIndex = ListBox.Items.Count - 1) then Exit;
	with ListBox do
	begin
		Index := ItemIndex;
		Items.BeginUpdate;
		Items.Insert(Index + 2, Items[Index]);
		Items.Delete(Index);
		Items.EndUpdate;
		ItemIndex := Index + 1;
	end;
	ListBox.SetFocus;
end;

procedure TThreadLibSortDlg.BitBtn1Click(Sender: TObject);
const
	TempDir = 'Katfav.tmp';
var
	I: Integer;
	FileName: TFileName;
begin
	if not CreateDirectory(TempDir, nil) then
	begin
		Application.MessageBox('TemptH_쐬Ɏs܂', PChar(Application.Title));
		Exit;
	end;

	{ ߋOɂTemptH_ֈړ }
	for I := 0 to ThreadLibraryList.Count - 1 do
	begin
		FileName := ThreadLibraryList[I] + '.idx';
		RenameFile(FileName, IncludeTrailingPathDelimiter(TempDir) + FileName);
	end;

	{ ԒʂɌ֖߂ }
	for I := 0 to ListBox.Items.Count - 1 do
	begin
		FileName := ListBox.Items[I] + '.idx';
		RenameFile(IncludeTrailingPathDelimiter(TempDir) + FileName, FileName);
	end;

	RemoveDirectory(TempDir);
end;

procedure TThreadLibSortDlg.ListBoxMouseDown(Sender: TObject;
	Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if (Button = mbLeft) and (ListBox.ItemIndex >= 0) then
	begin
		DragThreadIndex := ListBox.ItemIndex;
		ListBox.BeginDrag(False);
	end;
end;

procedure TThreadLibSortDlg.ListBoxDragOver(Sender, Source: TObject; X,
	Y: Integer; State: TDragState; var Accept: Boolean);
var
	Index: Integer;
begin
	Index := ListBox.ItemAtPos(Point(X, Y), True);
	if Index < 0 then
	begin
		Accept := False;
		Exit;
	end;
	if Index > DragThreadIndex then
	begin
		with ListBox do
		begin
			Items.Insert(Index + 1, Items[DragThreadIndex]);
			Items.Delete(DragThreadIndex);
			DragThreadIndex := Index;
		end;
	end else if Index < DragThreadIndex then
	begin
		with ListBox do
		begin
			Items.Insert(Index, Items[DragThreadIndex]);
			Items.Delete(DragThreadIndex + 1);
			DragThreadIndex := Index;
		end;
	end;
	ListBox.ItemIndex := DragThreadIndex;
end;

end.

