unit AboutDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, StrUtils, ExtCtrls;

type
  TAboutDialog = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    Label3: TLabel;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
		{ Public 錾 }
		class procedure Execute;
  end;

implementation

{$R *.dfm}

{ TAboutDialog }

class procedure TAboutDialog.Execute;
var
  AboutDialog: TAboutDialog;
begin
	AboutDialog := TAboutDialog.Create(Application.MainForm);
	try
		AboutDialog.ShowModal;
	finally
		AboutDialog.Free;
	end;
end;

procedure TAboutDialog.FormCreate(Sender: TObject);
var
	Size, I, Point: Integer;
	Data: DWORD;
	Buf, Value: PChar;
	VerStr: string;
	VerArray: array [0 .. 3] of Integer;
begin
	Size := GetFileVersionInfoSize(PChar(Application.ExeName), Data);
	if Size > 0 then
	begin
		Buf := AllocMem(Size);
		try
			GetFileVersionInfo(PChar(Application.ExeName), 0, Size, Buf);
			if VerQueryValue(Buf, '\StringFileInfo\041103A4\FileVersion', Pointer(Value), Data) then
			begin
				VerStr := Value;
				I := 0;
				while True do
				begin
					Point := Pos('.', VerStr);
					if Point = 0 then Break;
					VerArray[I] := StrToInt(LeftStr(VerStr, Point - 1));
					Delete(VerStr, 1, Point);
					Inc(I);
				end;
				if VerStr <> '' then VerArray[I] := StrToInt(VerStr);
				VerStr := Format('%d.%.2d Build #%d', [VerArray[0], VerArray[2], VerArray[3]]);
				Label3.Caption := Label3.Caption + VerStr;
			end;
		finally
			FreeMem(Buf);
		end;
	end;
end;

end.

