unit BoardView;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ComCtrls, ExtCtrls, Menus, ActnList, ImgList, Katjusha;

type
	TBoardViewTabs = (bvFavorites, bvBoards);
	TBoardViewParams = class
	public
		SubjectLoaded: Boolean;
	end;
  TBoardViewFrame = class(TFrame)
    TabControl1: TTabControl;
    Panel: TPanel;
    FavTreeView: TTreeView;
    BoardTreeView: TTreeView;
    ImageList: TImageList;
    PopupMenu: TPopupMenu;
    ActionList: TActionList;
    BrowserOpen: TAction;
    E1: TMenuItem;
    FavPopupMenu: TPopupMenu;
    ToolAddBoardButton: TAction;
    N1: TMenuItem;
    B1: TMenuItem;
    A1: TMenuItem;
    N2: TMenuItem;
    ToolOpenThreadList: TAction;
    O1: TMenuItem;
    ToolURLCopy: TAction;
    URLU1: TMenuItem;
    procedure PanelResize(Sender: TObject);
    procedure TabControl1Change(Sender: TObject);
    procedure FrameResize(Sender: TObject);
    procedure FavTreeViewDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure BrowserOpenExecute(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
    procedure ToolAddBoardButtonExecute(Sender: TObject);
    procedure ToolOpenThreadListExecute(Sender: TObject);
    procedure ToolURLCopyExecute(Sender: TObject);
  private
		{ Private 錾 }
		FBoardList: TStringList;
		PopupSelBoard: string;
		FPopupSelected: TTreeNode;
		FAllThreadNode: TTreeNode;		{ SXꗗ }
		function GetRootNode: TTreeNode;
    function GetClipBoardNode: TTreeNode;
		procedure LoadBoard;
    function GetSelectedBoard: string;
    procedure SetSelectedBoard(const Value: string);
    function GetAllThreadNode: TTreeNode;
    function GetSelected: T2chIndexList;
    function GetSelectedBoardParams: TBoardViewParams;
	public
		{ Public 錾 }
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure ChangeFavoritesTab;
		procedure ChangeBoardTab;
		procedure RemoveAllFavorites;
		procedure ClearViewParams;
		property RootNode: TTreeNode read GetRootNode;
		property ClipBoardNode: TTreeNode read GetClipBoardNode;
		property SelectedBoard: string read GetSelectedBoard write SetSelectedBoard;
		property AllThreadNode: TTreeNode read GetAllThreadNode;
		property Selected: T2chIndexList read GetSelected;
		property SelectedBoardParams: TBoardViewParams read GetSelectedBoardParams;
	end;

implementation

{$R *.dfm}

uses Clipbrd, regex, AWKFunc, FavUtils, FavMain, ThreadList;

const
	BOARD_2CHANNEL_BRD = '2channel.brd';
	BOARD_OTHER_BRD = 'other.brd';
	
constructor TBoardViewFrame.Create(AOwner: TComponent);
begin
  inherited;

	FBoardList := TStringList.Create;

	FavTreeView.Items.Add(nil, '`');
	FavTreeView.Items.Add(nil, 'Nbv{[h');

	FAllThreadNode := nil;
	 
	try
		LoadBoard;
	except
		on E: EFOpenError do {};
		else
			Raise;
	end;
end;

procedure TBoardViewFrame.PanelResize(Sender: TObject);
begin
	FavTreeView.BoundsRect := Panel.ClientRect;
	BoardTreeView.BoundsRect := Panel.ClientRect;
end;

procedure TBoardViewFrame.TabControl1Change(Sender: TObject);
begin
	if TabControl1.TabIndex = 0 then
	begin
		FavTreeView.Enabled := True;
		FavTreeView.BringToFront;
		BoardTreeView.Enabled := False;
	end else begin
		BoardTreeView.Enabled := True;
		BoardTreeView.BringToFront;
		FavTreeView.Enabled := False;
	end;
end;

procedure TBoardViewFrame.FrameResize(Sender: TObject);
begin
	Panel.Width := ClientWidth;
	Panel.Height := ClientHeight - TabControl1.Height + 1;
end;

function TBoardViewFrame.GetRootNode: TTreeNode;
begin
	Result := FavTreeView.Items[0];
end;

function TBoardViewFrame.GetClipBoardNode: TTreeNode;
begin
	Result := FavTreeView.Items[1];
end;

procedure TBoardViewFrame.FavTreeViewDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
	Accept := Source is TListView;
end;

procedure TBoardViewFrame.LoadBoard;
var
	List, Token: TStringList;
	I: Integer;
	r: regex_t;
	Root, Node: TTreeNode;
begin
	AWKCompilePattern(r, #9);

	Root := nil;
	List := nil;
	Token := nil;

	try
		List := TStringList.Create;
		Token := TStringList.Create;

		List.LoadFromFile(TKatjusha.GetKatjushaBaseDir + BOARD_2CHANNEL_BRD);

		for I := 1 to List.Count - 1 do
		begin
			Token.Clear;
			if AWKSplit(r, List[I], Token) <= 0 then Continue;
			if Token[0] <> '' then
				Root := BoardTreeView.Items.AddChild(nil, Token[0])
			else begin
				Assert(Root <> nil);
				Node := BoardTreeView.Items.AddChild(Root, Token[3]);
				Node.Data := Pointer(FBoardList.Add(Token[1] + '/' + Token[2]) + 1);
			end;
		end;

		Root := BoardTreeView.Items.AddChild(nil, '̑');
		List.LoadFromFile(TKatjusha.GetKatjushaBaseDir + BOARD_OTHER_BRD);
		for I := 0 to List.Count - 1 do
		begin
			Token.Clear;
			if AWKSplit(r, List[I], Token) < 3 then Continue;
			Node := BoardTreeView.Items.AddChild(Root, Token[2]);
			Node.Data := Pointer(FBoardList.Add(Token[0] + '/' + Token[1]) + 1);
		end;
	finally
		Token.Free;
		List.Free;
	end;
end;

destructor TBoardViewFrame.Destroy;
begin
	ClearViewParams;

	FBoardList.Free;
	if Assigned(FAllThreadNode) and Assigned(FAllThreadNode.Data) then
		T2chIndexList(FAllThreadNode.Data).Free;
		
  inherited;
end;

function TBoardViewFrame.GetSelectedBoard: string;
begin
	Result := '';
	
	with BoardTreeView do
	begin
		if Selected = nil then Exit;
		if Selected.Data = nil then Exit;

		Result := FBoardList[Integer(Selected.Data) - 1];
	end;
end;

procedure TBoardViewFrame.SetSelectedBoard(const Value: string);
var
	Item: TTreeNode;
begin
	Item := BoardTreeView.Items.GetFirstNode;
	while Item <> nil do
	begin
		if (Integer(Item.Data) > 0) and (FBoardList[Integer(Item.Data) - 1] = Value) then
			with Item do
			begin
				MakeVisible;
				Selected := True;
				ChangeBoardTab; { {[h^uɐ؂ւ }
				BoardTreeView.OnClick(BoardTreeView);
				Exit;
			end;
		Item := Item.GetNext;
	end;
end;

procedure TBoardViewFrame.BrowserOpenExecute(Sender: TObject);
var
	ServerName, BoardName: string;
begin
	if PopupSelBoard <> '' then
	begin
		AWKMatch1('^([^/]+)/', PopupSelBoard, ServerName);
		AWKMatch1('^[^/]+/(.+)$', PopupSelBoard, BoardName);

		CallBrowser((Application.MainForm as TKatfavMainForm).Katjusha.GetBoardUrl(ServerName, BoardName));
	end;
end;

procedure TBoardViewFrame.PopupMenuPopup(Sender: TObject);
begin
	PopupSelBoard := SelectedBoard;
	FPopupSelected := BoardTreeView.Selected;
end;

function TBoardViewFrame.GetAllThreadNode: TTreeNode;
var
	MainForm: TKatfavMainForm;
	IndexList: T2chIndexList;
begin
	MainForm := Owner as TKatfavMainForm;
	if not Assigned(FAllThreadNode) then
	begin
		FAllThreadNode := FavTreeView.Items.Add(nil, 'SXꗗ');
		IndexList := T2chIndexList.Create(MainForm.MasterIndex);
		FAllThreadNode.Data := Pointer(IndexList);
	end;

	GetAllThreadNode := FAllThreadNode;
end;

procedure TBoardViewFrame.ChangeFavoritesTab;
begin
	{ Cɓ^uɐ؂ւ }
	TabControl1.TabIndex := 0;
	TabControl1.OnChange(TabControl1);
end;

procedure TBoardViewFrame.RemoveAllFavorites;
var
	Node: TTreeNode;
begin
	{ SCɓ폜 }
	Node := RootNode.getFirstChild;
	repeat
		if Assigned(Node.Data) then
		begin
			T2chIndexList(Node.Data).Free;
			Node.Data := nil;
		end;

		Node := RootNode.GetNextChild(Node);
	until Node <> nil;

	RootNode.DeleteChildren;

	{ SXꗗ폜 }
	if Assigned(FAllThreadNode) then
	begin
		if Assigned(FAllThreadNode.Data) then
			with FAllThreadNode do
			begin
				T2chIndexList(Data).Free;
				Data := nil;
			end;

		FAllThreadNode.Delete;
		FAllThreadNode := nil;
	end;
end;

function TBoardViewFrame.GetSelected: T2chIndexList;
begin
	Result := nil;

	if TabControl1.TabIndex <> 0 then Exit;

	with FavTreeView do
		if (Selected <> nil) and (Selected.Data <> nil) then
			Result := T2chIndexList(Selected.Data);
end;

procedure TBoardViewFrame.ToolAddBoardButtonExecute(Sender: TObject);
begin
	if TabControl1.TabIndex = 0 then
	begin
		if Selected <> nil then
			(Owner as TKatfavMainForm).AddBoardButton(bbFavorites, FavTreeView.Selected.Text, '');
	end else begin
		if SelectedBoard <> '' then
			(Owner as TKatfavMainForm).AddBoardButton(bbBoards, FPopupSelected.Text, PopupSelBoard);
	end;
end;

procedure TBoardViewFrame.ChangeBoardTab;
begin
	{ {[h^uɐ؂ւ }
	TabControl1.TabIndex := 1;
	TabControl1.OnChange(TabControl1);
end;

procedure TBoardViewFrame.ToolOpenThreadListExecute(Sender: TObject);
var
	ThreadListForm: TThreadListForm;
begin
	ThreadListForm := TThreadListForm.Create(Application);
	try
		ThreadListForm.BoardPath := PopupSelBoard;
		ThreadListForm.Caption := FPopupSelected.Text + ThreadListForm.Caption;
		ThreadListForm.Show;
		ThreadListForm.NewThreadView.RefreshColumn;
	except
		ThreadListForm.Release;
		Raise;
	end;
end;

procedure TBoardViewFrame.ToolURLCopyExecute(Sender: TObject);
var
	ServerName, BoardName: string;
begin
	if PopupSelBoard <> '' then
	begin
		AWKMatch1('^([^/]+)/', PopupSelBoard, ServerName);
		AWKMatch1('^[^/]+/(.+)$', PopupSelBoard, BoardName);

		Clipbrd.Clipboard.AsText :=
			(Application.MainForm as TKatfavMainForm).Katjusha.GetBoardUrl(ServerName, BoardName);
	end;
end;

function TBoardViewFrame.GetSelectedBoardParams: TBoardViewParams;
begin
	Result := nil;
	
	with BoardTreeView do
	begin
		if Selected = nil then Exit;
		if Selected.Data = nil then Exit;

		Result := TBoardViewParams(FBoardList.Objects[Integer(Selected.Data) - 1]);
		if Result = nil then
		begin
			Result := TBoardViewParams.Create;
			FBoardList.Objects[Integer(Selected.Data) - 1] := Result;
		end;
	end;

end;

procedure TBoardViewFrame.ClearViewParams;
var
	I: Integer;
begin
	{ TBoardViewParams }
	for I := 0 to FBoardList.Count - 1 do
		if Assigned(FBoardList.Objects[I]) then
		begin
			FBoardList.Objects[I].Free;
			FBoardList.Objects[I] := nil;
		end;
end;

end.

