/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.control.pdf;

import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.skin.ButtonSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class TransitionButtonSkin
extends ButtonSkin {
    private Duration duration = Duration.millis((double)66.0);
    private ObjectProperty<Color> textColorProperty = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private ObjectProperty<Color> backgroundColorProperty = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private DoubleProperty opacityProperty = new SimpleDoubleProperty(0.0);
    private OpaqueBackgroundBinding backgroundBinding = new OpaqueBackgroundBinding(this.backgroundColorProperty, this.opacityProperty);
    private Color textEndColor = this.getTextColor();
    private Color backgroundEndColor = (Color)this.getBackgroundFill().getFill();

    public TransitionButtonSkin(Button control) {
        super(control);
        this.registerChangeListener((ObservableValue)control.focusedProperty(), o -> this.updateBackground());
        this.registerChangeListener((ObservableValue)control.hoverProperty(), o -> this.updateBackground());
        this.registerChangeListener((ObservableValue)control.pressedProperty(), o -> this.updateBackground());
    }

    protected Color getTextColor() {
        Paint paint = ((Button)this.getSkinnable()).getTextFill();
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return Color.TRANSPARENT;
    }

    protected BackgroundFill getBackgroundFill() {
        Paint paint;
        List fills;
        Background background = ((Button)this.getSkinnable()).getBackground();
        if (background != null && (fills = background.getFills()).size() > 0 && (paint = ((BackgroundFill)fills.get(0)).getFill()) instanceof Color) {
            return (BackgroundFill)fills.get(0);
        }
        return new BackgroundFill(null, null, null);
    }

    protected void updateBackground() {
        Button control = (Button)this.getSkinnable();
        control.textFillProperty().unbind();
        control.backgroundProperty().unbind();
        control.applyCss();
        this.textColorProperty.setValue((Object)this.textEndColor);
        this.backgroundColorProperty.setValue((Object)this.backgroundEndColor);
        this.opacityProperty.setValue((Number)(this.backgroundEndColor.getOpacity() == 0.0 ? 0.0 : 1.0));
        this.textEndColor = this.getTextColor();
        control.textFillProperty().bind(this.textColorProperty);
        BackgroundFill fill = this.getBackgroundFill();
        this.backgroundEndColor = (Color)fill.getFill();
        this.backgroundBinding.radii = fill.getRadii();
        this.backgroundBinding.insets = fill.getInsets();
        control.backgroundProperty().bind((ObservableValue)this.backgroundBinding);
        if (((Color)this.backgroundColorProperty.getValue()).getOpacity() > 0.0 && this.backgroundEndColor.getOpacity() > 0.0) {
            new Timeline(new KeyFrame[]{new KeyFrame(this.duration, new KeyValue[]{new KeyValue(this.textColorProperty, (Object)this.textEndColor), new KeyValue(this.backgroundColorProperty, (Object)this.backgroundEndColor)})}).play();
        } else if (((Color)this.backgroundColorProperty.getValue()).getOpacity() > 0.0) {
            new Timeline(new KeyFrame[]{new KeyFrame(this.duration, new KeyValue[]{new KeyValue(this.textColorProperty, (Object)this.textEndColor), new KeyValue((WritableValue)this.opacityProperty, (Object)0.0)})}).play();
        } else if (this.backgroundEndColor.getOpacity() > 0.0) {
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.ONE, new KeyValue[]{new KeyValue(this.backgroundColorProperty, (Object)this.backgroundEndColor)}), new KeyFrame(this.duration, new KeyValue[]{new KeyValue(this.textColorProperty, (Object)this.textEndColor), new KeyValue((WritableValue)this.opacityProperty, (Object)1.0)})}).play();
        } else {
            new Timeline(new KeyFrame[]{new KeyFrame(this.duration, new KeyValue[]{new KeyValue(this.textColorProperty, (Object)this.textEndColor)})}).play();
        }
    }

    private class OpaqueBackgroundBinding
    extends ObjectBinding<Background> {
        private ObjectProperty<Color> colorProperty;
        private DoubleProperty opacityProperty;
        private CornerRadii radii;
        private Insets insets;

        public OpaqueBackgroundBinding(ObjectProperty<Color> colorProperty, DoubleProperty opacityProperty) {
            this.colorProperty = colorProperty;
            this.opacityProperty = opacityProperty;
            this.bind(new Observable[]{colorProperty, opacityProperty});
        }

        protected Background computeValue() {
            Color c = (Color)this.colorProperty.getValue();
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getOpacity() * this.opacityProperty.getValue());
            return new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, this.radii, this.insets)});
        }
    }
}

