/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.control.pdf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Region;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfView
extends Region {
    private ObjectProperty<PDDocument> documentProperty = new SimpleObjectProperty((Object)this, "document");
    private IntegerProperty pageIndexProperty = new SimpleIntegerProperty((Object)this, "pageIndex");
    private IntegerProperty maxPageIndexProperty = new SimpleIntegerProperty((Object)this, "maxPageIndex");
    private DoubleProperty renderScaleProperty = new SimpleDoubleProperty((Object)this, "renderScale");
    private ObjectProperty<Rectangle2D> renderBounds = new SimpleObjectProperty((Object)this, "renderBounds", (Object)Rectangle2D.EMPTY);
    private RenderingHints renderingHints;
    private ProgressIndicator progressIndicator;
    private Canvas canvas;
    private boolean isSizeDirty;
    private boolean isPageDirty;
    private boolean isBusy;
    private ExecutorService worker = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    });
    private double width;
    private double height;
    private double scale;
    private int initialPageIndex;
    private PDDocument document;
    private int pageIndex;
    private BufferedImage bimg;
    private WritableImage wimg;

    public ObjectProperty<PDDocument> documentProperty() {
        return this.documentProperty;
    }

    public final PDDocument getDocument() {
        return (PDDocument)this.documentProperty.get();
    }

    public final void setDocument(PDDocument value) {
        this.initialPageIndex = 0;
        this.documentProperty.set((Object)value);
    }

    public final void setDocument(PDDocument value, int pageIndex) {
        this.initialPageIndex = value == null || pageIndex < 0 ? 0 : (pageIndex >= value.getNumberOfPages() ? value.getNumberOfPages() - 1 : pageIndex);
        this.documentProperty.set((Object)value);
    }

    public IntegerProperty pageIndexProperty() {
        return this.pageIndexProperty;
    }

    public final int getPageIndex() {
        return this.pageIndexProperty.get();
    }

    public final void setPageIndex(int value) {
        this.pageIndexProperty.set(value);
    }

    public ReadOnlyIntegerProperty maxPageIndexProperty() {
        return this.maxPageIndexProperty;
    }

    public final int getMaxPageIndex() {
        return this.maxPageIndexProperty.get();
    }

    public final void setMaxPageIndex(int value) {
        this.maxPageIndexProperty.set(value);
    }

    public ReadOnlyDoubleProperty renderScaleProperty() {
        return this.renderScaleProperty;
    }

    public final double getRenderScale() {
        return this.renderScaleProperty.get();
    }

    public ReadOnlyObjectProperty<Rectangle2D> renderBoundsProperty() {
        return this.renderBounds;
    }

    public Rectangle2D getRenderBounds() {
        return (Rectangle2D)this.renderBounds.get();
    }

    public PdfView() {
        this.canvas = new Canvas();
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.canvas);
        this.progressIndicator = new ProgressIndicator();
        this.progressIndicator.setVisible(false);
        this.getChildren().add((Object)this.progressIndicator);
        this.documentProperty.addListener((observable, oldValue, newValue) -> {
            this.pageIndexProperty.set(this.initialPageIndex);
            if (newValue == null) {
                this.maxPageIndexProperty.set(0);
            } else {
                this.maxPageIndexProperty.set(newValue.getNumberOfPages() - 1);
            }
            this.updatePage();
        });
        this.pageIndexProperty.addListener((observable, oldValue, newValue) -> this.updatePage());
        this.widthProperty().addListener((observable, oldValue, newValue) -> {
            double width = this.getWidth();
            double height = this.getHeight();
            Platform.runLater(() -> {
                if (width == this.getWidth() && height == this.getHeight()) {
                    this.updateSize();
                }
            });
        });
        this.heightProperty().addListener((observable, oldValue, newValue) -> {
            double width = this.getWidth();
            double height = this.getHeight();
            Platform.runLater(() -> {
                if (width == this.getWidth() && height == this.getHeight()) {
                    this.updateSize();
                }
            });
        });
    }

    public void setRenderingHints(RenderingHints hints) {
        this.renderingHints = hints;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void updatePage() {
        this.isPageDirty = true;
        this.update();
    }

    public void updateSize() {
        this.isSizeDirty = true;
        this.update();
    }

    private void update() {
        if (!this.isBusy) {
            this.isBusy = true;
            this.isPageDirty = false;
            this.isSizeDirty = false;
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.document = (PDDocument)this.documentProperty.get();
            this.pageIndex = this.pageIndexProperty.get();
            this.worker.submit(() -> {
                WritableImage img = this.prepare();
                Platform.runLater(() -> {
                    this.isBusy = false;
                    if (this.isSizeDirty) {
                        this.updateSize();
                    } else {
                        this.renderScaleProperty.set(this.scale);
                        GraphicsContext gc = this.canvas.getGraphicsContext2D();
                        gc.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
                        if (img != null) {
                            double x = (this.canvas.getWidth() - img.getWidth()) / 2.0;
                            double y = (this.canvas.getHeight() - img.getHeight()) / 2.0;
                            gc.drawImage((Image)img, x, y);
                            this.renderBounds.set((Object)new Rectangle2D(x, y, img.getWidth(), img.getHeight()));
                        } else {
                            this.renderBounds.set((Object)Rectangle2D.EMPTY);
                        }
                        if (this.isPageDirty) {
                            this.updatePage();
                        }
                    }
                });
            });
        }
    }

    protected WritableImage prepare() {
        double h;
        double w;
        if (this.document == null) {
            this.scale = 0.0;
            return null;
        }
        PDRectangle paper = this.document.getPage(this.pageIndex).getCropBox();
        if ((double)(paper.getWidth() / paper.getHeight()) < this.width / this.height) {
            w = this.height * (double)paper.getWidth() / (double)paper.getHeight();
            h = this.height;
        } else {
            w = this.width;
            h = this.width * (double)paper.getHeight() / (double)paper.getWidth();
        }
        this.scale = h / (double)paper.getHeight();
        if (this.bimg == null || this.bimg.getWidth() != (int)w || this.bimg.getHeight() != (int)h) {
            this.bimg = new BufferedImage((int)w, (int)h, 1);
            this.wimg = new WritableImage((int)w, (int)h);
        }
        Graphics2D graphics = null;
        try {
            graphics = this.bimg.createGraphics();
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, (int)w, (int)h);
            PDFRenderer renderer = new PDFRenderer(this.document);
            if (this.renderingHints != null) {
                renderer.setRenderingHints(this.renderingHints);
            }
            renderer.renderPageToGraphics(this.pageIndex, graphics, (float)this.scale);
            WritableImage writableImage = SwingFXUtils.toFXImage((BufferedImage)this.bimg, (WritableImage)this.wimg);
            return writableImage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    protected void layoutChildren() {
        this.progressIndicator.relocate((this.getWidth() - this.progressIndicator.getWidth()) / 2.0, (this.getHeight() - this.progressIndicator.getHeight()) / 2.0);
        super.layoutChildren();
    }

    public Task<PDDocument> load(final Callable<PDDocument> loader, final int initialPageIndex) {
        Task<PDDocument> task = new Task<PDDocument>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected PDDocument call() throws Exception {
                try {
                    PDDocument document = (PDDocument)loader.call();
                    Graphics graphics = null;
                    try {
                        PDFRenderer renderer = new PDFRenderer(document);
                        BufferedImage bimg = new BufferedImage(1, 1, 1);
                        graphics = bimg.createGraphics();
                        int max = Math.min(10, document.getNumberOfPages());
                        for (int i = 0; i < max; ++i) {
                            renderer.renderPageToGraphics(i, (Graphics2D)graphics);
                        }
                    }
                    finally {
                        if (graphics != null) {
                            graphics.dispose();
                        }
                    }
                    Platform.runLater(() -> PdfView.this.setDocument(document, initialPageIndex));
                    PDDocument pDDocument = document;
                    return pDDocument;
                }
                finally {
                    Platform.runLater(() -> PdfView.this.progressIndicator.setVisible(false));
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            this.setDocument(null);
            this.progressIndicator.setVisible(true);
            this.worker.execute((Runnable)task);
        } else {
            try {
                PdfView.runAndWait(() -> {
                    this.setDocument(null);
                    this.progressIndicator.setVisible(true);
                });
                task.run();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return task;
    }

    public Task<PDDocument> load(File file) {
        return this.load(() -> PDDocument.load((File)file), 0);
    }

    public Task<PDDocument> load(File file, int initialPageIndex) {
        return this.load(() -> PDDocument.load((File)file), initialPageIndex);
    }

    public Task<PDDocument> load(File file, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((File)file, (MemoryUsageSetting)memUsageSetting), 0);
    }

    public Task<PDDocument> load(File file, int initialPageIndex, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((File)file, (MemoryUsageSetting)memUsageSetting), initialPageIndex);
    }

    public Task<PDDocument> load(File file, String password) {
        return this.load(() -> PDDocument.load((File)file, (String)password), 0);
    }

    public Task<PDDocument> load(File file, int initialPageIndex, String password) {
        return this.load(() -> PDDocument.load((File)file, (String)password), initialPageIndex);
    }

    public Task<PDDocument> load(File file, String password, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((File)file, (String)password, (MemoryUsageSetting)memUsageSetting), 0);
    }

    public Task<PDDocument> load(File file, int initialPageIndex, String password, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((File)file, (String)password, (MemoryUsageSetting)memUsageSetting), initialPageIndex);
    }

    public Task<PDDocument> load(File file, String password, InputStream keyStore, String alias) {
        return this.load(() -> PDDocument.load((File)file, (String)password, (InputStream)keyStore, (String)alias), 0);
    }

    public Task<PDDocument> load(File file, int initialPageIndex, String password, InputStream keyStore, String alias) {
        return this.load(() -> PDDocument.load((File)file, (String)password, (InputStream)keyStore, (String)alias), initialPageIndex);
    }

    public Task<PDDocument> load(File file, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((File)file, (String)password, (InputStream)keyStore, (String)alias, (MemoryUsageSetting)memUsageSetting), 0);
    }

    public Task<PDDocument> load(File file, int initialPageIndex, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((File)file, (String)password, (InputStream)keyStore, (String)alias, (MemoryUsageSetting)memUsageSetting), initialPageIndex);
    }

    public Task<PDDocument> load(InputStream input) {
        return this.load(() -> PDDocument.load((InputStream)input), 0);
    }

    public Task<PDDocument> load(InputStream input, int initialPageIndex) {
        return this.load(() -> PDDocument.load((InputStream)input), initialPageIndex);
    }

    public Task<PDDocument> load(InputStream input, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((InputStream)input, (MemoryUsageSetting)memUsageSetting), 0);
    }

    public Task<PDDocument> load(InputStream input, int initialPageIndex, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((InputStream)input, (MemoryUsageSetting)memUsageSetting), initialPageIndex);
    }

    public Task<PDDocument> load(InputStream input, String password) {
        return this.load(() -> PDDocument.load((InputStream)input, (String)password), 0);
    }

    public Task<PDDocument> load(InputStream input, int initialPageIndex, String password) {
        return this.load(() -> PDDocument.load((InputStream)input, (String)password), initialPageIndex);
    }

    public Task<PDDocument> load(InputStream input, String password, InputStream keyStore, String alias) {
        return this.load(() -> PDDocument.load((InputStream)input, (String)password, (InputStream)keyStore, (String)alias), 0);
    }

    public Task<PDDocument> load(InputStream input, int initialPageIndex, String password, InputStream keyStore, String alias) {
        return this.load(() -> PDDocument.load((InputStream)input, (String)password, (InputStream)keyStore, (String)alias), initialPageIndex);
    }

    public Task<PDDocument> load(InputStream input, String password, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((InputStream)input, (String)password, (MemoryUsageSetting)memUsageSetting), 0);
    }

    public Task<PDDocument> load(InputStream input, int initialPageIndex, String password, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((InputStream)input, (String)password, (MemoryUsageSetting)memUsageSetting), initialPageIndex);
    }

    public Task<PDDocument> load(InputStream input, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((InputStream)input, (String)password, (InputStream)keyStore, (String)alias, (MemoryUsageSetting)memUsageSetting), 0);
    }

    public Task<PDDocument> load(InputStream input, int initialPageIndex, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((InputStream)input, (String)password, (InputStream)keyStore, (String)alias, (MemoryUsageSetting)memUsageSetting), initialPageIndex);
    }

    public Task<PDDocument> load(byte[] input) {
        return this.load(() -> PDDocument.load((byte[])input), 0);
    }

    public Task<PDDocument> load(byte[] input, int initialPageIndex) {
        return this.load(() -> PDDocument.load((byte[])input), initialPageIndex);
    }

    public Task<PDDocument> load(byte[] input, String password) {
        return this.load(() -> PDDocument.load((byte[])input, (String)password), 0);
    }

    public Task<PDDocument> load(byte[] input, int initialPageIndex, String password) {
        return this.load(() -> PDDocument.load((byte[])input, (String)password), initialPageIndex);
    }

    public Task<PDDocument> load(byte[] input, String password, InputStream keyStore, String alias) {
        return this.load(() -> PDDocument.load((byte[])input, (String)password, (InputStream)keyStore, (String)alias), 0);
    }

    public Task<PDDocument> load(byte[] input, int initialPageIndex, String password, InputStream keyStore, String alias) {
        return this.load(() -> PDDocument.load((byte[])input, (String)password, (InputStream)keyStore, (String)alias), initialPageIndex);
    }

    public Task<PDDocument> load(byte[] input, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((byte[])input, (String)password, (InputStream)keyStore, (String)alias, (MemoryUsageSetting)memUsageSetting), 0);
    }

    public Task<PDDocument> load(byte[] input, int initialPageIndex, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) {
        return this.load(() -> PDDocument.load((byte[])input, (String)password, (InputStream)keyStore, (String)alias, (MemoryUsageSetting)memUsageSetting), initialPageIndex);
    }

    protected static void runAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (Platform.isFxApplicationThread()) {
            throw new Error("Cannot call runAndWait from the FX Application Thread");
        }
        Throwable[] throwable = new Throwable[1];
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
            finally {
                latch.countDown();
            }
            latch.countDown();
        });
        latch.await();
        if (throwable[0] != null) {
            throw new InvocationTargetException(throwable[0]);
        }
    }
}

