/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.control;

import java.util.concurrent.Callable;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import net.osdn.util.javafx.event.SilentCallable;
import net.osdn.util.javafx.event.SilentCallback;
import net.osdn.util.javafx.event.SilentChangeListener;
import net.osdn.util.javafx.event.SilentChangeListenerNewValueOnly;
import net.osdn.util.javafx.event.SilentChangeListenerWithoutObservable;
import net.osdn.util.javafx.event.SilentEventHandler;
import net.osdn.util.javafx.event.SilentInvalidationListener;
import net.osdn.util.javafx.event.SilentRunnable;
import net.osdn.util.javafx.scene.control.Dialogs;

public class DialogEx<R>
extends Dialog<R> {
    public DialogEx(final Window owner) {
        if (owner instanceof Stage) {
            Stage stage = (Stage)this.getDialogPane().getScene().getWindow();
            ObservableList icons = ((Stage)owner).getIcons();
            if (icons != null && icons.size() > 0) {
                stage.getIcons().add((Object)((Image)icons.get(0)));
            }
            stage.setTitle(((Stage)owner).getTitle());
        }
        if (owner != null) {
            this.getDialogPane().layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

                public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                    if (newValue != null && newValue.getWidth() > 0.0 && newValue.getHeight() > 0.0) {
                        double x = owner.getX() + owner.getWidth() / 2.0;
                        double y = owner.getY() + owner.getHeight() / 2.0;
                        DialogEx.this.setX(x - newValue.getWidth() / 2.0);
                        DialogEx.this.setY(y - newValue.getHeight() / 2.0);
                        DialogEx.this.getDialogPane().layoutBoundsProperty().removeListener((ChangeListener)this);
                    }
                }
            });
        }
        this.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    DialogPane dialogPane = DialogEx.this.getDialogPane();
                    for (ButtonType buttonType : dialogPane.getButtonTypes()) {
                        String text = Dialogs.buttonTexts.get(buttonType);
                        if (text == null) continue;
                        Button button = (Button)dialogPane.lookupButton(buttonType);
                        button.setText(text);
                    }
                }
                DialogEx.this.showingProperty().removeListener((ChangeListener)this);
            }
        });
    }

    protected <T extends Event> EventHandler<T> wrap(SilentEventHandler<T> handler) {
        return SilentEventHandler.wrap(handler);
    }

    protected <P, R> Callback<P, R> wrap(SilentCallback<P, R> callback) {
        return SilentCallback.wrap(callback);
    }

    protected <T> ChangeListener<T> wrap(SilentChangeListener<T> listener) {
        return SilentChangeListener.wrap(listener);
    }

    protected <T> ChangeListener<T> wrap(SilentChangeListenerWithoutObservable<T> listener) {
        return SilentChangeListenerWithoutObservable.wrap(listener);
    }

    protected <T> ChangeListener<T> wrap(SilentChangeListenerNewValueOnly<T> listener) {
        return SilentChangeListenerNewValueOnly.wrap(listener);
    }

    protected InvalidationListener wrap(SilentInvalidationListener listener) {
        return SilentInvalidationListener.wrap(listener);
    }

    protected Runnable wrap(SilentRunnable runnable) {
        return SilentRunnable.wrap(runnable);
    }

    protected <V> Callable<V> wrap(SilentCallable<V> callable) {
        return SilentCallable.wrap(callable);
    }
}

