/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene.control;

import java.util.Map;
import java.util.WeakHashMap;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.stage.WindowEvent;

public class ContextMenuUtil {
    private static Map<ContextMenu, EventHandler<WindowEvent>> fixEventHandlers = new WeakHashMap<ContextMenu, EventHandler<WindowEvent>>();

    public static MenuBar fix(MenuBar menuBar) {
        if (menuBar == null) {
            return null;
        }
        for (Menu menu : menuBar.getMenus()) {
            ContextMenuUtil.fix(menu);
        }
        return menuBar;
    }

    public static Menu fix(Menu menu) {
        if (menu == null) {
            return null;
        }
        for (MenuItem menuItem : menu.getItems()) {
            ContextMenuUtil.fix(menuItem);
        }
        return menu;
    }

    public static MenuItem fix(MenuItem menuItem) {
        if (menuItem == null) {
            return null;
        }
        menuItem.parentPopupProperty().addListener((observable, oldValue, newValue) -> {
            EventHandler<WindowEvent> oldEventHandler;
            if (oldValue != null && (oldEventHandler = fixEventHandlers.get(oldValue)) != null) {
                oldValue.removeEventHandler(WindowEvent.WINDOW_SHOWING, oldEventHandler);
            }
            if (newValue != null) {
                ContextMenuUtil.fix(newValue, false);
            }
        });
        return menuItem;
    }

    public static ContextMenu fix(ContextMenu contextMenu) {
        return ContextMenuUtil.fix(contextMenu, true);
    }

    public static ContextMenu fix(final ContextMenu contextMenu, final boolean hideOnMouseReleased) {
        if (contextMenu == null) {
            return null;
        }
        EventHandler<WindowEvent> oldEventHandler = fixEventHandlers.get(contextMenu);
        if (oldEventHandler != null) {
            contextMenu.removeEventHandler(WindowEvent.WINDOW_SHOWING, oldEventHandler);
        }
        EventHandler<WindowEvent> newEventHandler = new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                Node contextMenuNode = contextMenu.getStyleableNode();
                for (MenuItem menuItem : contextMenu.getItems()) {
                    Node menuItemNode = menuItem.getStyleableNode();
                    if (menuItemNode == null) continue;
                    menuItemNode.setOnMouseExited(me -> contextMenuNode.requestFocus());
                    menuItemNode.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> {
                        if (!menuItemNode.isFocused()) {
                            e.consume();
                            if (hideOnMouseReleased) {
                                contextMenu.hide();
                            }
                        }
                    });
                }
                contextMenuNode.requestFocus();
                contextMenu.removeEventHandler(WindowEvent.WINDOW_SHOWING, (EventHandler)this);
            }
        };
        contextMenu.addEventHandler(WindowEvent.WINDOW_SHOWING, (EventHandler)newEventHandler);
        fixEventHandlers.put(contextMenu, newEventHandler);
        return contextMenu;
    }
}

