/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import javafx.beans.value.ChangeListener;
import net.osdn.util.javafx.event.SilentWrappedException;

@FunctionalInterface
public interface SilentChangeListenerNewValueOnly<T> {
    public void changed(T var1) throws Exception;

    public static <T> ChangeListener<T> wrap(SilentChangeListenerNewValueOnly<T> listener) {
        return (observable, oldValue, newValue) -> {
            try {
                listener.changed(newValue);
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                    return;
                }
                throw new SilentWrappedException(e);
            }
        };
    }
}

