/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javafx.concurrent.Task;
import net.osdn.util.javafx.concurrent.AsyncCallable;
import net.osdn.util.javafx.concurrent.AsyncRunnable;

public class Async<V>
implements AsyncRunnable,
AsyncCallable<V> {
    private static ThreadFactory defaultThreadFactory;
    private static Executor executor;
    private Task<V> task;
    private Cancel cancel;
    private AsyncRunnable.Success runnableSuccess;
    private AsyncCallable.Success<V> callableSuccess;
    private Failure failure;
    private Complete complete;

    public static ThreadFactory getDefaultThreadFactory() {
        return defaultThreadFactory;
    }

    public static void setDefaultThreadFactory(ThreadFactory factory) {
        defaultThreadFactory = factory;
        executor = null;
    }

    public static Executor getExecutor() {
        if (executor == null) {
            ThreadFactory factory = Async.getDefaultThreadFactory();
            if (factory == null) {
                factory = new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r);
                        thread.setDaemon(true);
                        return thread;
                    }
                };
            }
            executor = Executors.newCachedThreadPool(factory);
        }
        return executor;
    }

    public static void setExecutor(Executor executor) {
        Async.executor = executor;
    }

    public static AsyncRunnable execute(Runnable runnable) {
        Async<Void> async = new Async<Void>(() -> {
            runnable.run();
            return null;
        });
        Async.getExecutor().execute((Runnable)async.task);
        return async;
    }

    public static <V> AsyncCallable<V> execute(Callable<V> callable) {
        Async<V> async = new Async<V>(callable);
        Async.getExecutor().execute((Runnable)async.task);
        return async;
    }

    private Async(final Callable<V> callable) {
        this.task = new Task<V>(){

            protected V call() throws Exception {
                return callable.call();
            }

            protected void cancelled() {
                Async.this.cancelled();
            }

            protected void succeeded() {
                Async.this.succeeded();
            }

            protected void failed() {
                Async.this.failed();
            }
        };
    }

    protected void cancelled() {
        if (this.cancel != null) {
            this.cancel.onCancelled();
        }
        if (this.complete != null) {
            this.complete.onCompleted(State.CANCELLED);
        }
    }

    protected void succeeded() {
        if (this.runnableSuccess != null) {
            this.runnableSuccess.onSucceeded();
        } else if (this.callableSuccess != null) {
            this.callableSuccess.onSucceeded(this.task.getValue());
        }
        if (this.complete != null) {
            this.complete.onCompleted(State.SUCCEEDED);
        }
    }

    protected void failed() {
        if (this.failure != null) {
            this.failure.onFailed(this.task.getException());
        }
        if (this.complete != null) {
            this.complete.onCompleted(State.FAILED);
        }
    }

    public Task<V> getTask() {
        return this.task;
    }

    @Override
    public Async<V> onCancelled(Cancel callback) {
        this.cancel = callback;
        return this;
    }

    @Override
    public Async<V> onSucceeded(AsyncRunnable.Success callback) {
        this.callableSuccess = null;
        this.runnableSuccess = callback;
        return this;
    }

    @Override
    public Async<V> onSucceeded(AsyncCallable.Success<V> callback) {
        this.runnableSuccess = null;
        this.callableSuccess = callback;
        return this;
    }

    @Override
    public Async<V> onFailed(Failure callback) {
        this.failure = callback;
        return this;
    }

    @Override
    public Async<V> onCompleted(Complete callback) {
        this.complete = callback;
        return this;
    }

    @FunctionalInterface
    public static interface Complete {
        public void onCompleted(State var1);
    }

    @FunctionalInterface
    public static interface Failure {
        public void onFailed(Throwable var1);
    }

    @FunctionalInterface
    public static interface Cancel {
        public void onCancelled();
    }

    public static enum State {
        CANCELLED,
        SUCCEEDED,
        FAILED;

    }
}

