/*
 *	browser.js - ブラウザチェック用スクリプト
 *
 *		著作者:
 *			HIROTAKA.YAMASHITA. 2008. - sousyu.yama@gmail.com 
 *
 *		ライセンス:
 *			The MIT License¶
 *
 *			Copyright (c) 2008 HIROTAKA YAMASHITA.
 *
 *			以下に定める条件に従い、本ソフトウェアおよび関連文書のファイル（以下「ソフトウェア」）の
 *			複製を取得するすべての人に対し、ソフトウェアを無制限に扱うことを無償で許可します。これには、
 *			ソフトウェアの複製を使用、複写、変更、結合、掲載、頒布、サブライセンス、および/または
 *			販売する権利、およびソフトウェアを提供する相手に同じことを許可する権利も無制限に含まれます。
 *
 *			上記の著作権表示および本許諾表示を、ソフトウェアのすべての複製または重要な部分に記載する
 *			ものとします。
 *
 *			ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、何らの保証もなく提供されます。
 *			ここでいう保証とは、商品性、特定の目的への適合性、および権利非侵害についての保証も含みますが、
 *			それに限定されるものではありません。作者または著作権者は、契約行為、不法行為、
 *			またはそれ以外であろうと、ソフトウェアに起因または関連し、あるいはソフトウェアの使用または
 *			その他の扱いによって生じる一切の請求、損害、その他の義務について何らの責任も負わないものとします。 
 *
 *			Permission is hereby granted, free of charge, to any person obtaining a copy
 *			of this software and associated documentation files (the "Software"), to deal
 *			in the Software without restriction, including without limitation the rights
 *			to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *			copies of the Software, and to permit persons to whom the Software is
 *			furnished to do so, subject to the following conditions:
 *
 *			The above copyright notice and this permission notice shall be included in
 *			all copies or substantial portions of the Software.
 *
 *			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *			IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *			FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *			AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *			LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *			OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *			THE SOFTWARE.
 *
 *		Flash バージョンは 9 以上が必要
 *
 *		以下のブラウザを推奨するスクリプト
 *			Windows:	Internet Explorer 7 以上
 *			Windows:	Firefox 2 以上
 *			Windows:	Safari 3 以上
 *			Windows:	Opera 9 以上
 *			Mac:		Firefox 2 以上
 *			Mac:		Safari 2 以上
 *			Mac:		Opera 9 以上
 *
 */
if(typeof shadewww=="undefined"){
	var shadewww=new Object();
}
////////////////////////////////////////////////////////////////////////////////////////////
shadewww.Browser = function() {
	this.wwwFlag = false; 
	this.ieFlag = false;
};
////////////////////////////////////////////////////////////////////////////////////////////
shadewww.Browser.prototype = {
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	Flash プラグインの確認 (バージョン9以上)
//
//		引数:	1		:p要素でメッセージ出力
//				2		:警告ダイアログでメッセージ出力
//				それ以外	:メッセージ非表示
//		戻り値:	true	:インストール済み
//				false	:未インストール
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	isFlashPlugin: function (flag, id) {
		var pluginFlag = false;

		if (this.isIE() || !navigator.plugins) {
			try {
				var flash = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.7");
				var verStr = flash.GetVariable("$version");
				var verAry = verStr.split(",", 1);
				var version = verAry[0].replace(/WIN /i,'');
				if (version >= 9){
					pluginFlag = true;
				}
			} catch (ex) {}
		} else {
			if (navigator.mimeTypes['application/x-shockwave-flash']) {
				var flash = navigator.mimeTypes['application/x-shockwave-flash'].enabledPlugin;
				if (flash && flash.description) {
					var verAry = flash.description.split(".", 1);
					var version = verAry[0].replace(/^[A-Za-z\s]+/, '');
					if (version >= 9){
						pluginFlag = true;
					}
				}
			}
		}

		if (!pluginFlag) {
															// Flash 未インストール時のメッセージ
			var msg = "Flash ver.9 or later プラグインがインストールされていません。";
			if (flag == 1) {
				if(typeof id=="undefined"){
					id = "";
				} else {
					id = ' id="' + id + '"';
				}
				document.write('<p' + id + '>' + msg + '</p>');
			} else if (flag == 2) {
				alert(msg);
			}
		}
		return pluginFlag;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	InternetExplorerの確認
//
//		引数:	なし
//		戻り値:	true	:使用ブラウザはIE
//				false	:使用ブラウザはIE以外
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	isIE: function () {
		return this.ieFlag;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	サポート対象外ブラウザの確認
//
//		引数:	なし
//		戻り値:	true	:使用ブラウザは対象外
//				false	:使用ブラウザは対象
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	isOther: function () {
		return !this.wwwFlag;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	ブラウザチェック (推奨ブラウザかチェック)
//
//		引数:	1		:p要素でメッセージ出力
//				2		:警告ダイアログでメッセージ出力
//				それ以外	:メッセージ非表示
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	checkBrowser: function (disp, id) {
		var msg = "";
		var ua = navigator.userAgent.toUpperCase();
		var os = this.getOperatingSystem(ua);
		var valid = this.validBrowser(ua, os);
		if (!valid || !document.getElementById) {
																	//非推奨ブラウザ用メッセージ
			msg =  "お使いのブラウザ環境は検証されていません。";
			msg += "正常に表示できない可能性があります。";
		} else {
			valid = this.versionCheck(ua, os);
			if (!valid) {
														//推奨ブラウザのバージョン違い用メッセージ
				msg = "お使いのブラウザバージョンでは、正常に表示できない可能性があります。";
			} else {
				this.wwwFlag = true;
			}
		}
		if (msg) {
			if (disp == 1) {
				if(typeof id=="undefined"){
					id = "";
				} else {
					id = ' id="' + id + '"';
				}
				document.write('<p' + id + '>' + msg + '</p>');
			} else if (disp == 2) {
				alert(msg);
			}
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	ブラウザバージョンチェック
//
//		引数:	ua		:navigator.userAgent の値
//				os		:OS名 (WIN:Windows, MAC:Macintosh, OTHER:それ以外)
//		戻り値:	true	:対応済みバージョン
//				false	:未対応バージョン
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	versionCheck: function (ua, os) {
		for (var i = 0; i < this.validData.length; i++) {
			var bName = this.validData[i].name;
			var bOs   = this.validData[i].os;
			var idx = ua.indexOf(bName);
			if (idx != -1 && bOs == os)	{
				idx = ua.indexOf(this.validData[i].versionString);
				if (idx == -1) break;
				var bVersion = this.validData[i].version;
				var vStr = ua.substring(idx + this.validData[i].versionString.length);
				var version  = parseFloat(vStr);
				return (bVersion <= version) ? true : false;
			}
		}
		return false;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	検証対象ブラウザの確認
//
//		引数:	ua		:navigator.userAgent の値
//				os		:OS名 (WIN:Windows, MAC:Macintosh, OTHER:それ以外)
//		戻り値:	true	:検証対象ブラウザ
//				false	:未対象バージョン
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	validBrowser: function (ua, os) {
		for (var i = 0; i < this.validData.length; i++) {
			var bName = this.validData[i].name;
			var bOs   = this.validData[i].os;
			var idx = ua.indexOf(bName);
			if (idx != -1 && bOs == os)	{
				if (this.validData[i].name == "MSIE") {
					this.ieFlag = true;
				} else {
					this.ieFlag = false;
				}
				return true;
			}
		}
		return false;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	OSの判定
//
//		引数:	ua		:navigator.userAgent の値
//		戻り値:	WIN		:Windows
//				MAC		:Macintosh
//				OTHER	:上記以外
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	getOperatingSystem: function (ua) {
		var idx = ua.indexOf("WINDOWS");
		if (idx != -1) {
			return "WIN";
		}
		idx = ua.indexOf("MAC");
		if (idx != -1) {
			return "MAC";
		}
		return "OTHER";
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	対象ブラウザデータ
//
//		navigator.userAgent の値による判定に使用
//
//		name			:ブラウザ名
//		os				:OS名
//		versionString	:バージョン情報区切り文字列
//		version			:推奨バージョン番号
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	validData: [
		{
			name:			"MSIE",
			os:				"WIN",
			versionString:	"MSIE ",
			version:		7
		},
		{
			name:			"SAFARI",
			os:				"WIN",
			versionString:	"SAFARI/",
			version:		522
		},
		{
			name:			"SAFARI",
			os:				"MAC",
			versionString:	"SAFARI/",
			version:		412
		},
		{
			name:			"FIREFOX",
			os:				"WIN",
			versionString:	"FIREFOX/",
			version:		2
		},
		{
			name:			"FIREFOX",
			os:				"MAC",
			versionString:	"FIREFOX/",
			version:		2
		},
		{
			name:			"OPERA",
			os:				"WIN",
			versionString:	"OPERA/",
			version:		9
		},
		{
			name:			"OPERA",
			os:				"MAC",
			versionString:	"OPERA/",
			version:		9
		}
	]
};
////////////////////////////////////////////////////////////////////////////////////////////
if(typeof Browser=="undefined"){
	var Browser = new shadewww.Browser();
}
// で始まる行はコメントアウトされます。
//Browser.checkBrowser(0);	//メッセージ非表示
//Browser.checkBrowser(1);	//p要素でメッセージ表示
//Browser.checkBrowser(2);	//警告ダイアログでメッセージ表示
