package org.apache.jetspeed.portal.portlets;

// Turbine stuff
import org.apache.turbine.util.RunData;

// Jetspeed stuff
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.portal.service.PersistenceService;
import org.apache.jetspeed.portal.service.ServiceFactory;
import org.apache.jetspeed.portal.service.ServiceException;


/**
An abstract portlet supporting min/max/restore/conf/close buttons

@author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
*/
public abstract class AbstractVTLPortlet extends AbstractPortlet
{

    /**
    By default the data is non cacheable
    */
    public void init( ) throws PortletException
    {
        setCacheable( false );
    }

    /**
    All portlets can be minimized only if there is a user logged in

    @param rundata A RunData object
    */
    public boolean getAllowMinimize( RunData rundata )
    {
        return rundata.getUser() != null && rundata.getUser().hasLoggedIn();
    }

    /**
    All portlets can be closed only if there is a user logged in

    @param rundata A RunData object
    */
    public boolean getAllowClose( RunData rundata )
    {
        return rundata.getUser() != null && rundata.getUser().hasLoggedIn();
    }

    /**
    Retrieve a portlet attribute from persistent storage

    @param attrName The attribute to retrieve
    @parm attrDefValue The value if the attr doesn't exists
    @param rundata A RunData object
    @return The attribute value
    */
    public String getAttribute( String attrName, String attrDefValue, RunData rundata )
    {
        String attrValue = null ;

        try
        {
            Object[] params = { this };
            PersistenceService ps = (PersistenceService)ServiceFactory
                                        .getService( PersistenceService.class,
                                                     rundata, params);
            attrValue = ps.getPage().getAttribute( attrName );
            if( attrValue == null )
            {
                attrValue = attrDefValue ;
            }
        }
        catch ( ServiceException e )
        {
            attrValue = attrDefValue ;
        }

        return attrValue;
    }

    /**
    A way to store a portlet attribute in persistent storage

    @param attrName The attribute to retrieve
    @parm attrValue The value to store
    @param rundata A RunData object
    */
    public void setAttribute( String attrName, String attrValue, RunData rundata )
    {
        try
        {
            Object[] params = { this };
            PersistenceService ps = (PersistenceService)ServiceFactory
                                        .getService( PersistenceService.class,
                                                     rundata, params);
            ps.getPage().setAttribute( attrName, attrValue );
            ps.store();
        }
        catch ( ServiceException e ) {}
    }

    /**
    Change the portlet visibility state ( minimized <-> normal )

    @param minimize True if the portlet change to minimized
    @param rundata A RunData object
    */
    public void setMinimized( boolean minimize, RunData rundata )
    {
        if( this.getAllowMinimize( rundata ) )
        {
            this.setAttribute("minimized", minimize ? "true" : "false", rundata );
        }
    }

    /**

    @param rundata A RunData object
    @return True if the portlet is currently minimized
    */
    public boolean isMinimized( RunData rundata )
    {
        return this.getAttribute("minimized", "false", rundata ).equals("true");
    }

    /**
    A way to detect if the max button was clicked

    @param rundata A RunData object
    @return True if max button clicked
    */
    public boolean isButtonMaximize( RunData rundata )
    {
        String portlet = rundata.getParameters().getString ( "portlet", "" );
        String button  = rundata.getParameters().getString ( "button", "" );

        return portlet.equals( this.getName() ) && button.equals("maximize");
    }

    /**
    A way to detect if the config button was clicked

    @param rundata A RunData object
    @return True if config button clicked
    */
    public boolean isButtonConfigure( RunData rundata )
    {
        String portlet = rundata.getParameters().getString ( "portlet", "" );
        String button  = rundata.getParameters().getString ( "button", "" );

        return portlet.equals( this.getName() ) && button.equals("configure");
    }


}
