/*
 *  ====================================================================
 *  The Apache Software License, Version 1.1
 *
 *  Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 *  reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in
 *  the documentation and/or other materials provided with the
 *  distribution.
 *
 *  3. The end-user documentation included with the redistribution,
 *  if any, must include the following acknowledgment:
 *  "This product includes software developed by the
 *  Apache Software Foundation (http://www.apache.org/)."
 *  Alternately, this acknowledgment may appear in the software itself,
 *  if and wherever such third-party acknowledgments normally appear.
 *
 *  4. The names "Apache" and "Apache Software Foundation" and
 *  "Apache Jetspeed" must not be used to endorse or promote products
 *  derived from this software without prior written permission. For
 *  written permission, please contact apache@apache.org.
 *
 *  5. Products derived from this software may not be called "Apache" or
 *  "Apache Jetspeed", nor may "Apache" appear in their name, without
 *  prior written permission of the Apache Software Foundation.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 *  ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 *  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 *  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  ====================================================================
 *
 *  This software consists of voluntary contributions made by many
 *  individuals on behalf of the Apache Software Foundation.  For more
 *  information on the Apache Software Foundation, please see
 *  <http://www.apache.org/>.
 */

package org.apache.jetspeed.util.ant;

import java.io.File;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;

import org.apache.jetspeed.util.OverwriteProperties;

/**
 * <code>OverwritePropertiesTask</code> is the task definition for an Ant
 * interface to the <code>OverwriteProperties</code>.
 * 
 * @created January 29, 2003
 * @author Eric Pugh
 * @version $Revision: 1.2 $
 * @see org.apache.tools.ant.Task
 */

public class OverwritePropertiesTask extends Task
{
    /** File to merge properties into */
    private File mergeBaseProperties;

    /** File to merge properties from */
    private File mergeProperties;

    /** Directory to look for includes in */
    private File includesDir;

    /** Fail on error flag */
    private boolean failonerror = true;

    /**
     *  Sets the File to merge properties into
     * 
     * @param mergeBaseProperties
     *               File to merge properties into
     */

    public void setMergeBaseProperties(File mergeBaseProperties)
    {
        this.mergeBaseProperties = mergeBaseProperties;
    }

    /**
     *  Sets the File to merge properties from
     *
     * @param  mergeProperties  File to merge properties from
     */

    public void setMergeProperties(File mergeProperties)
    {
        this.mergeProperties = mergeProperties;
    }

    /**
     *  Sets the Directory to look for includes in
     *
     * @param  includesDir  Directory to look for includes in
     */
    public void setIncludesDir(File includesDir)
    {

        this.includesDir = includesDir;
    }

    /**
     * If false, note errors to the output but keep going.
     * @param failonerror true or false
     */
     public void setFailOnError(boolean failonerror) 
     {
         this.failonerror = failonerror;
     }

    /**
     *  Gets the File to merge properties into
     * 
     * @return File to merge properties into
     */
    public File getMergeBaseProperties()
    {

        return mergeBaseProperties;
    }

    /**
     *  Gets the File to merge properties from
     * 
     * @return File to merge properties from
     */
    public File getMergeProperties()
    {

        return mergeProperties;
    }

    /**
     *  Gets the Directory to look for includes in
     * 
     * @return Directory to look for includes in
     */
    public File getIncludesDir()
    {

        return includesDir;
    }

    /**
     * Load the step and then execute it
     * 
     * @exception BuildException
     *                   Description of the Exception
     */
    public void execute() throws BuildException 
    {

        try
        {
            OverwriteProperties overwriteProperties = new OverwriteProperties();
            overwriteProperties.setBaseProperties(getMergeBaseProperties());
            overwriteProperties.setProperties(getMergeProperties());
            overwriteProperties.setIncludeRoot(getIncludesDir());

            overwriteProperties.execute();
        }
        catch (Exception e)
        {
            if (!this.failonerror) 
            {
                log(e.toString());
            } 
            else 
            {
                throw new BuildException(e.toString());
            }
        }
    }
}
