/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */


package org.apache.jetspeed.util;

import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LineCounter
{
    int count = 0;

    public static void main( String args[] )
    {
        LineCounter lc = new LineCounter();
        int count = 0;
        int totalCount = 0;
        for (int ix = 0; ix < args.length; ix++)
        {
            count = lc.run(args[ix]);
            System.out.println( "Count for path [" + args[ix] + "] = " + count );
            totalCount += count;
        }
        System.out.println( "Total Count = " + totalCount );
    }

    public int run(String path)
    {
        System.out.println("Running LineCounter for " + path );
        count = 0;
        return traverse(path);
    }

    private int traverse(String path)
    {
        File file = new File(path);
        if (file.isFile()) 
        {
            try 
            {
                String name = file.getName();
                if (name.endsWith("java"))
                    count += countFile(file);
            }
            catch (Exception e)
            {
                System.err.println("Failed to count file: " + path + " : " + e.toString());
            }
        } 
        else if (file.isDirectory()) 
        {
            if (!path.endsWith(File.separator))
                path += File.separator;

    //        System.out.println("Processing directory: " + path);
            String list[] = file.list();

            // Process all files recursivly
            for(int ix = 0; list != null && ix < list.length; ix++)
                traverse(path + list[ix]);


        }
        return count;
    }            

    private int countFile( File file )
            throws FileNotFoundException, IOException
    {
  //      System.out.println("Processing file: " + file.getPath());
        FileReader reader = new FileReader( file );
        BufferedReader br = new BufferedReader( reader );
        String s;
        int mycount = 0;

        while ((s = br.readLine()) != null)
        {
            if (s.length() > 0)
                mycount++;
        }
        return mycount;
    }
}

