/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.util;

import javax.mail.internet.MimeUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

/**
 * Simple Base64 string decoding function
 * @author Jason Borden <jborden@javasense.com>
 *
 * This class was copied from the jakarta-james project.
 * The only change made, besides comments, is the package name.
 * This class orgininated in org.apache.james.util as version 1.3
 * which was committed by darrel on 2002/01/18 02:48:39
 * 
 * $Id: Base64.java,v 1.4 2003/03/04 00:05:15 sgala Exp $
 * Committed on $Date: 2003/03/04 00:05:15 $ by: $Name:  $ 
 */

public class Base64 {

    public static String decodeAsString(String b64string) throws Exception
    {
        return new String(decodeAsByteArray(b64string));
    }

    public static byte[] decodeAsByteArray(String b64string) throws Exception
    {
        InputStream in = MimeUtility.decode(new ByteArrayInputStream(
                         b64string.getBytes()), "base64");

        ByteArrayOutputStream out = new ByteArrayOutputStream();
        
        while(true)
        {
            int b = in.read();
            if (b == -1) break;
            else out.write(b);
        }
    
        return out.toByteArray();
    }

    public static String encodeAsString(String plaintext) throws Exception
    {
        return encodeAsString(plaintext.getBytes());
    }

    public static String encodeAsString(byte[] plaindata) throws Exception
    {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream inStream = new ByteArrayOutputStream();

        inStream.write(plaindata, 0, plaindata.length);

        // pad
        if ((plaindata.length % 3 ) == 1)
        {
            inStream.write(0);
            inStream.write(0);
        }
        else if((plaindata.length % 3 ) == 2)
        {
            inStream.write(0);
        }

        inStream.writeTo(MimeUtility.encode(out, "base64"));
        return out.toString();
    }

}

