/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.webpage;

// javax.servlet
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

// java.io
import java.io.IOException;

// java.util
import java.util.Collection;

/**
 * <P>This is a commodity static accessor class around the
 * <code>WebPageService</code> interface</P>
 *
 * @see org.apache.jetspeed.services.webpage.WebPageService
 * 
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: WebPageManager.java,v 1.1 2003/02/12 08:12:28 taylor Exp $
 */

public class WebPageManager
{

    // the singleton service reference
    private static WebPageService service = null;
   

    /** 
     * Commodity method for getting a reference to the service
     * singleton
     */
    private static WebPageService getService()
    {        
        if (service == null)
        {
            // TODO: load from configuration
            service = new JetspeedWebPageService();
        }
        return service;
    }
    
    /**
     * @see WebPageService#isInit
     */
    public static boolean isInit()
    {
       return getService().isInit();
    }

    /**
     * @see WebPageService#get
     */
    public static void get(HttpServlet servlet, 
                           HttpServletRequest request, 
                           HttpServletResponse response)
                           throws ServletException, IOException    
    {
       getService().get(servlet, request, response);
    }

    /**
     * @see WebPageService#post
     */
    public static void post(HttpServlet servlet, 
                            HttpServletRequest request, 
                            HttpServletResponse response)
        throws ServletException, IOException
    {
       getService().post(servlet, request, response);
    }


    /**
     * @see WebPageService#init
     */
    public static void init(ServletConfig config)
            throws ServletException, IOException
    {
        getService().init(config);
    }

    /**
     * @see WebPageService#destroy
     */
    public static void destroy()
    {
        getService().destroy();
    }

    /**
     * @see WebPageService#getSessions
     */
    public static Collection getSessions()
    {
        return getService().getSessions();
    }

    /**
     * @see WebPageService#getSession
     */
    public static SessionMap getSession(String id)
    {
        return getService().getSession(id);
    }

    /**
     * @see WebPageService#getNetworkElements
     */
    public static Collection getSites()
    {
        return getService().getSites();
    }

    /**
     * @see WebPageService#getErrorString
     */
    public static String getErrorString()
    {
        return getService().getErrorString();
    }

}
