/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.webpage;

import javax.servlet.http.*;

/**
 * State information per request, easily passed within proxy service.
 * 
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: ProxyRunData.java,v 1.1 2003/02/12 08:12:28 taylor Exp $ 
 */

public class ProxyRunData
{
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpServlet servlet;
    private boolean posting = false;

    /*
     * Construct a rundata object. Only lives per one request.
     *
     * @param servlet The HTTP Servlet object that contains the proxy server.
     * @param request The HTTP Request.
     * @param response The HTTP Response.
     * @param posting If true it means we are in a HTTP POST, otherwise HTTP GET.
     */
    ProxyRunData( HttpServlet servlet,
                  HttpServletRequest request,
                  HttpServletResponse response,
                  boolean posting)
    {
        this.servlet = servlet;
        this.request = request;
        this.response = response;
        this.posting = posting;
    }

    /*
     * Gets the HttpServlet for this request.
     *
     * @return The HttpServlet object for this request.
     *
     */
    public HttpServlet getServlet()
    {
        return servlet;
    }

    /*
     * Gets the HttpServletRequest for this request.
     *
     * @return The HttpServletRequest object for this request.
     *
     */
    public HttpServletRequest getRequest()
    {
        return request;
    }

    /*
     * Gets the HttpServletResponse for this request.
     *
     * @return The HttpServletResponse object for this request.
     *
     */
    public HttpServletResponse getResponse()
    {
        return response;
    }

    /*
     * Gets the state of this request, either a HTTP post or get.
     *
     * @return The state of the request, true for post, false for get.
     *
     */
    public boolean getPosting()
    {
        return posting;
    }

}

