/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.urlmanager;

import org.apache.turbine.services.TurbineServices;
import java.util.List;

/**
 * <p>This is a static wrapper around the URLManagerService for easing 
 * access to its functionalities</p>
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: URLManager.java,v 1.6 2001/09/10 22:04:15 sgala Exp $
 */
public class URLManager {

    /** 
     * @see URLManagerService#STATUS_ANY
     */
    public static int STATUS_ANY = URLManagerService.STATUS_ANY;

    /** 
     * @see URLManagerService#STATUS_UNKNOWN
     */
    public static int STATUS_UNKNOWN = URLManagerService.STATUS_UNKNOWN;

    /** 
     * @see URLManagerService#STATUS_OK
     */
    public static int STATUS_OK = URLManagerService.STATUS_OK;

    /** 
     * @see URLManagerService#STATUS_UNREACHABLE
     */
    public static int STATUS_UNREACHABLE = URLManagerService.STATUS_UNREACHABLE;

    /** 
     * @see URLManagerService#STATUS_TEMPORARY_UNAVAILABLE
     */
    public static int STATUS_TEMPORARY_UNAVAILABLE = URLManagerService.STATUS_TEMPORARY_UNAVAILABLE;

    /** 
     * @see URLManagerService#STATUS_CONTENT_ERROR
     */
    public static int STATUS_CONTENT_ERROR = URLManagerService.STATUS_CONTENT_ERROR;
    
    /** 
     * @see URLManagerService#STATUS_BAD
     */
    public static int STATUS_BAD = URLManagerService.STATUS_BAD;

    /** 
     * @see URLManagerService#register
     */
    public static void register( String url ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        ums.register( url );
    }

    /** 
     * @see URLManagerService#register
     */
    public static void register( String url, int status ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        ums.register( url, status );
    }

    /** 
     * @see URLManagerService#register
     */
    public static void register( String url, int status, String message ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        ums.register( url, status, message );
    }

    /** 
     * @see URLManagerService#register
     */
    public static void register( URLInfo info ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        ums.register( info );
    }

    /** 
     * @see URLManagerService#unregister
     */
    public static void unregister( String url ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        ums.unregister( url );
    }

    /** 
     * @see URLManagerService#getInfo
     */
    public static URLInfo getInfo( String url ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        return ums.getInfo( url );
    }
    
    /** 
     * @see URLManagerService#isOK
     */
    public static boolean isOK( String url ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        return ums.isOK( url );
    }
    
    /** 
     * @see URLManagerService#list
     */
    public static List list() {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        return ums.list();
    }
        
    /** 
     * @see URLManagerService#list
     */
    public static List list( int status ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        return ums.list( status );
    }

    /** 
     * @see URLManagerService#getProxyPort
     */
    public static int getProxyPort( String protocol ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        return ums.getProxyPort( protocol );
    }
    
    /** 
     * @see URLManagerService#getProxyHost
     */
    public static String getProxyHost( String protocol ) {
        URLManagerService ums = (URLManagerService)TurbineServices
            .getInstance()
            .getService( URLManagerService.SERVICE_NAME );
        
        return ums.getProxyHost( protocol );
    }
}
