/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.urlmanager;

/**
 * <p>This is a simple URL information record which can be used
 * to track URL resources status in a persistent way.</p>
 *
 * <p>The url String used to initialize it MUST be interned,
 * to ensure that if two such urls are "equal()", they will be
 * also "==" </p>
 *
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: URLInfo.java,v 1.4 2001/05/29 09:29:55 sgala Exp $
 */
public class URLInfo implements java.io.Serializable {
        
    private String url;
    private int status;
    private String message;

    /**
     * Creates a new minimum URLInfo record
     *
     * @param url a non-null url described by this class
     */
    URLInfo( String url ) {
        this( url, URLManagerService.STATUS_UNKNOWN, null );
    }
        
    /**
     * Creates a new URLInfo record
     *
     * @param url a non-null url described by this class
     * @param status the status of this url
     */
    URLInfo( String url, int status ) {
        this( url, status, null );
    }
        
    /**
     * Creates a new URLInfo record
     *
     * @param url a non-null url described by this class
     * @param status the status of this url
     * @param message a message suitable for display describing
     * the status of the url
     */
    URLInfo( String url, int status, String message ) {
        this.url = url.intern();
        this.status = status;
        this.message = message;
    }
        
    /**
     * Get the url.
     *
     * @return the url string described by this object
     */
    public String getURL() {
        return this.url;
    }
        
    /**
     * Get the status
     *
     * @return the status for this url
     */
    public int getStatus() {
        return status;
    }
        
    /**
     * Set the status
     *
     * @param status the status for this url
     */
    public void setStatus( int status ) {
        this.status = status;
    }

    /**
     * Get the message
     *
     * @return the message for this url
     */
    public String getMessage() {
        return message;
    }
        
    /**
     * Set the message
     *
     * @param message the message for this url
     */
    public void setMessage( String message ) {
        this.message = message;
    }

}
