/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2004 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */


package org.apache.jetspeed.services.security;

import java.util.HashMap;
import java.util.Iterator;

import org.apache.jetspeed.om.security.BaseJetspeedGroup;
import org.apache.jetspeed.om.security.BaseJetspeedGroupRole;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.GroupRole;
import org.apache.jetspeed.om.security.Role;

/**
 * Cached ACL - default implementation cached ACL containing role/permission.
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a> 
 * @version $Id: CachedAcl.java,v 1.4 2004/01/06 20:26:16 morciuch Exp $
 */
public class CachedAcl
{
	protected HashMap groupRoles = new HashMap();
	protected String userName;

	/**
	 * @param userName
	 */
	public CachedAcl(String userName)
	{
		this.userName = userName;
	}

	/**
	 * @param role
	 */
	public void addRole(Role role)
	{
		Group group = new BaseJetspeedGroup();
		group.setName(GroupManagement.DEFAULT_GROUP_NAME);
		addRole(role, group);
	}

	/**
	 * @param role
	 * @param group
	 */
	public void addRole(Role role, Group group)
	{
		GroupRole gr = new BaseJetspeedGroupRole();
		gr.setRole(role);
		gr.setGroup(group);
		String key = getGroupRoleKey(group.getName(), role.getName());
		groupRoles.put(key, gr);
	}

	/**
	 * @param roleName
	 * @return
	 */
	public Role getRole(String roleName)
	{
		return getRole(roleName, GroupManagement.DEFAULT_GROUP_NAME);
	}

	/**
	 * @param roleName
	 * @param groupName
	 * @return
	 */
	public Role getRole(String roleName, String groupName)
	{
		GroupRole gr = (GroupRole) groupRoles.get(getGroupRoleKey(groupName, roleName));
		return gr != null ? gr.getRole() : null;
	}

	/**
	 * @return
	 */
	public Iterator getRoles()
	{
		return groupRoles.values().iterator();
	}

	/**
	 * @return
	 */
	public String getUserName()
	{
		return this.userName;
	}

	/**
	 * @param roleName
	 * @return
	 */
	public boolean hasRole(String roleName)
	{
		return hasRole(roleName, GroupManagement.DEFAULT_GROUP_NAME);
	}

	/**
	 * @param roleName
	 * @param groupName
	 * @return
	 */
	public boolean hasRole(String roleName, String groupName)
	{
		return groupRoles.containsKey(getGroupRoleKey(groupName, roleName));
	}

	/**
	 * @param roleName
	 */
	public void removeRole(String roleName)
	{
		removeRole(roleName, GroupManagement.DEFAULT_GROUP_NAME);
	}
	
	/**
	 * @param roleName
	 * @param groupName
	 */
	public void removeRole(String roleName, String groupName)
	{
		groupRoles.remove(getGroupRoleKey(groupName, roleName));
	}

	/**
	 * @param grouproles
	 */
	public void setRoles(Iterator grouproles)
	{
		while (grouproles.hasNext())
		{
			GroupRole grouprole = (GroupRole) grouproles.next();
			String key = getGroupRoleKey(grouprole.getGroup().getName(), grouprole.getRole().getName());
			this.groupRoles.put(key, grouprole);
		}
	}

	/**
	 * @param groupName
	 * @param roleName
	 * @return
	 */
	private String getGroupRoleKey(String groupName, String roleName)
	{
		StringBuffer key = new StringBuffer();
		key.append(groupName);
		key.append(roleName);
		
		return key.toString();
	}

}
