/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.search;

import java.net.URL;

import junit.awtui.TestRunner;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.test.HeadlessBaseTest;

/**
 * Test Search Service 
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * 
 * @version $Id: TestSearch.java,v 1.3 2003/06/20 17:05:48 morciuch Exp $
 */
public class TestSearch extends HeadlessBaseTest
{
        
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestSearch(String name)
    {
        super(name);
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        TestRunner.main(new String[] { TestSearch.class.getName() });
    }
    
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite(TestSearch.class);
    }

    public void testRemoveWebPage() throws Exception
    {
        System.out.println("search home = " + JetspeedResources.getString("services.SearchService.directory"));
        URL jetspeedHomePage = new URL("http://jakarta.apache.org/jetspeed/");
        assertNotNull("Created URL to Jetspeed Home Page",  jetspeedHomePage);
        assertTrue("Removing non-existent index entry", Search.remove(jetspeedHomePage) == false);
        assertTrue("Adding to index", Search.add(jetspeedHomePage));
        assertTrue("Removing from index", Search.remove(jetspeedHomePage));
    }
    
    public void testPutWebPage() throws Exception
    {
        System.out.println("search home = " + JetspeedResources.getString("services.SearchService.directory"));
        URL jetspeedHomePage = new URL("http://jakarta.apache.org/jetspeed");
        assertNotNull("Created URL to Jetspeed Home Page",  jetspeedHomePage);
        assertTrue("Adding to index", Search.add(jetspeedHomePage));
        assertTrue("Adding to index", Search.add(new URL("http://www.google.com")));
        assertTrue("Adding to index", Search.add(new URL("http://jakarta.apache.org")));
    }
    
    /**
     *
     * @throws Exception
     */
    public void testVerifyJetspeedSearch() throws Exception
    {
        ParsedObject result = null;
        SearchResults results  = Search.search("rss");
        System.out.println("Query 'rss' hits = " + results.size());
        assertTrue(" Hit count > 0", results.size() > 0);
        for (int i = 0; i < results.size(); i++)
        {
            result = results.get(i);
            System.out.println("Score = " + result.getScore());
            System.out.println("title = " + result.getTitle());
            System.out.println("summary = " + result.getDescription());
            System.out.println("url = " + result.getURL());
        }
    }
    
    public void testVerifyJetspeedSearch1() throws Exception
    {
        ParsedObject result = null;
        SearchResults results  = Search.search("Jetspeed");
        System.out.println("Query 'Jetspeed' hits = " + results.size());
        assertTrue(" Hit count > 0", results.size() > 0);
        for (int i = 0; i < results.size(); i++)
        {
            result = results.get(i);
            System.out.println("Score = " + result.getScore());
            System.out.println("title = " + result.getTitle());
            System.out.println("summary = " + result.getDescription());
            System.out.println("url = " + result.getURL());
        }
    }
    
    public void testVerifyJetspeedSearch2() throws Exception
    {
        ParsedObject result = null;
        SearchResults results  = Search.search("google");
        System.out.println("Query 'goggle' hits = " + results.size());
        assertTrue(" Hit count > 0", results.size() > 0);
        for (int i = 0; i < results.size(); i++)
        {
            result = results.get(i);
            System.out.println("Score = " + result.getScore());
            System.out.println("title = " + result.getTitle());
            System.out.println("summary = " + result.getDescription());
            System.out.println("url = " + result.getURL());
        }
    }

}
