/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2004 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.registry;

import java.util.Iterator;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.om.registry.*;

import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.om.registry.base.CategoryIterator;

/**
 * TestRegistryCategories
 *
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestRegistryCategories.java,v 1.12 2004/01/06 20:26:16 morciuch Exp $
 */

public class TestRegistryCategories extends JetspeedTestCase {

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestRegistryCategories( String name ) {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestRegistryCategories.class.getName() } );
    }
 
    public void setup() {
        System.out.println("Setup: Testing categories of Registry");
     }
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestRegistryCategories.class );
    }

    /**
     * Tests categories
     * @throws Exception
     */
    public void testCategories() throws Exception 
    {
        try
        {
            PortletRegistry registry = (PortletRegistry)Registry.get(Registry.PORTLET);

            PortletEntry pe = (PortletEntry)registry.getEntry("RSS");
            assertNotNull(pe);

            Iterator iterator = registry.findPortletsByCategory("rss");
            int count = 0;
            init();
            PortletEntry rss;
            while (iterator.hasNext())
            {
                rss = (PortletEntry)iterator.next();
                print(iterator, rss);
                count++;
            }
            System.out.println("[RSS] count = " + count);
            System.out.println("------------------");            
            assertEquals( "RSS Count", 10, count);
            //assertEquals( "RSS Count", 2, count);

            registry.removeEntry(pe);
            iterator = registry.findPortletsByCategory("rss");
            assertTrue(iterator.hasNext());
            //assertTrue(iterator.hasNext());
            //assertTrue(iterator.hasNext());
            //assertTrue(iterator.hasNext());
            //assertTrue(iterator.hasNext());
              
            registry.addEntry(pe);
            iterator = registry.findPortletsByCategory("rss");
            assertTrue(iterator.hasNext());
            rss = (PortletEntry)iterator.next();
            Iterator cats = rss.listCategories();
            assertNotNull(cats);
            assertTrue(cats.hasNext());
            Category cat = (Category)cats.next();
            assertTrue(cat.getName().startsWith("rss") || cat.getName().startsWith("news"));


            iterator = registry.listByCategory();
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
            //    print(iterator, entry);
                count++;
            }
            System.out.println("[Everything] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByCategory("General");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[General] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByGroupCategory("base", "news.xml.rss");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[base][xml.rss] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByCategory("");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByGroupCategory("", "");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[][] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByGroupCategory("Jetspeed", "");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[Jetspeed][] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByCategory("news");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[news] count = " + count);
            System.out.println("------------------");

           
//            SortedMap sm = tree.tailMap("sports");
//            Iterator it = sm.keySet().iterator();
        }
        catch (Exception e)
        {
            String errmsg = "Error in category test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    private String lastGroup = "";
    private String lastCategory = "";

    private void init()
    {
        lastGroup = "";
        lastCategory = "";
    }

    private void print(Iterator iterator, PortletEntry entry)
    {
        String group = ((CategoryIterator)iterator).getGroup();
        String category = ((CategoryIterator)iterator).getCategory();
        if (!lastGroup.equals(group))
        {
            System.out.println("Group: [" + group + "]");
            lastGroup = group;
        }
        if (!lastCategory.equals(category))
        {
            System.out.println("....Cat: [" + category + "]");
            lastCategory = category;
        }
        System.out.println("........" + entry.getName());
     }
    
    /**
     * Tests IdentityElement unmarshaling entryset base stuff
     * @throws Exception
     */


    /*
      Configuration object to run Turbine outside a servlet container
      ( uses turbine.properties )
    */
    private static TurbineConfig config = null;
    
    /*    
      Sets up TurbineConfig using the system property:
      <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
           config = new TurbineConfig( "../webapp", "/WEB-INF/conf/TurbineResources.properties");
           config.init();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }
}
