package org.apache.jetspeed.services.jsp.tags;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

// Turbine Classes 
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.jsp.JspService;

// Jetsped Classes 
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.URILookup;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.portal.PortletURIManager;

/**
 * Supporting class for the uriLookup tag.
 * Returns the URL for the respective link
 *
 * @author <a href="mailto:ingo@raleigh.ibm.com">Ingo Schuster</a>
 */
public class URILookupTag extends TagSupport 
{
    /**
     * Static initialization of the logger for this class
     */    
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(URILookupTag.class.getName());
    
    /**
     * type parameter defines type of URI that is requested
     */
    private String type;

    /** 
     * The setter for type parameter
     */
    public void setType(String type)
    {
        this.type = type;
    }

    public int doStartTag() throws JspException 
    {
        RunData data = (RunData)pageContext.getAttribute(JspService.RUNDATA, PageContext.REQUEST_SCOPE);    

        try
        {           
            String result = null;

            /* HOME */
            if (type.equalsIgnoreCase( "Home" )) {
              result = URILookup.getURI(URILookup.TYPE_HOME, URILookup.SUBTYPE_NONE, data);
            }  

            /* LOGIN */
            if (type.equalsIgnoreCase( "Login" )) {
              result = URILookup.getURI(URILookup.TYPE_LOGIN, URILookup.SUBTYPE_NONE, data);
            }  

            /* ENROLLMENT */
            if (type.equalsIgnoreCase( "Enrollment" )) {
              result = URILookup.getURI(URILookup.TYPE_ENROLLMENT, URILookup.SUBTYPE_NONE, data);
            }  

            /* LOGOUT */
            if (type.equalsIgnoreCase( "Logout" )) {
              result = URILookup.getURI(URILookup.TYPE_HOME, URILookup.SUBTYPE_LOGOUT, data);
            }  

            /* CUSTOMIZE */
            if (type.equalsIgnoreCase( "Customize") ) {
              result = URILookup.getURI(URILookup.TYPE_CUSTOMIZE, URILookup.SUBTYPE_NONE, data);
            }  

            /* EDIT ACCOUNT */
            if (type.equalsIgnoreCase( "EditAccount" )) {
              result = URILookup.getURI(URILookup.TYPE_EDIT_ACCOUNT, URILookup.SUBTYPE_NONE, data);
            }  

            /* APPLICATIONS */
            if (type.equalsIgnoreCase( "Applications" )) {
              PortletEntry entry = null;
              entry = (PortletEntry)Registry.getEntry( Registry.PORTLET, "Applications" );
              result = PortletURIManager.getPortletMaxURI( entry, data ).toString();
            }  

            /* BASE URL */
            if (type.equalsIgnoreCase( "BaseURL" )) {
              result = URILookup.getWebAppBaseDirURI( data );
            }   

            if (result != null) {
              pageContext.getOut().print(result);
            } else {
              throw new Exception( "jetspeed-URILookup tag: Unknown parameter!");
            }
        }
        catch (Exception e)
        {
            String message = "Error processing uriLookup-tag, parameter: "+ type;
            logger.error(message, e);
            try
            {
                data.getOut().print( "Error processing uriLookup-tag, parameter: "+ type);
            }
            catch(java.io.IOException ioe) {}    
        }
        return EVAL_BODY_INCLUDE;
    }

}
