/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.daemonfactory;

import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.daemon.DaemonContext;
import org.apache.jetspeed.daemon.DaemonException;
import org.apache.jetspeed.daemon.DaemonNotFoundException;
import org.apache.turbine.services.Service;

/**
@author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
@version $Id: DaemonFactoryService.java,v 1.3 2001/09/04 12:06:58 sgala Exp $
*/
public interface DaemonFactoryService extends Service {
    
    public String SERVICE_NAME = "DaemonFactory";
    
    /**
    <p>
    Starts any daemons that need processing.
    </p>
    
    <p>
    This should be called right after init() so that any daemons that need to be 
    started will be.  If you need to do any per-daemon initialization then do so 
    before calling start()
    </p>
    */
    public void start();    
    
    /**
    Allows a Daemon to define its Thread priority through a factory.  The Thread
    that this object should return should be an implementation of itself.
    */
    public Daemon getDaemon( DaemonEntry entry ) throws DaemonException;

    /**
    Get a daemon with the given classname.
    
    @see    #getDaemon( DaemonEntry entry )
    */
    public Daemon getDaemon( String classname ) throws DaemonException;

    /**
    */
    public DaemonContext getDaemonContext();

    /**
    Kicks of processing of a Daemon.  Does the same thing as getDaemon() but
    also creates a thread and runs the daemon.
    */
    public void process( DaemonEntry entry ) throws DaemonException;

    /**
    */
    public int getStatus(DaemonEntry entry);

    /**
    Get the last known result of the given DaemonEntry's processing
    */
    public int getResult(DaemonEntry entry);

    /**
    Get the last known message of the given DaemonEntry's processing
    */
    public String getMessage( DaemonEntry entry );
    
    /**
    Get the current known DaemonEntries within the DaemonFactory
    */
    public DaemonEntry[] getDaemonEntries();

    /**
    Given the name of a DaemonEntry... get it from the DaemonFactory 
    */
    public DaemonEntry getDaemonEntry(String name) 
        throws DaemonNotFoundException;
    
}
