/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.services.customlocalization;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

// Java APIs
import java.util.Locale;

import org.apache.jetspeed.test.HeadlessBaseTest;

/**
 * Command Line Test Localization routines.
 *
 * @author <a href="mailto:morciuch@">Mark Orciuch</a>
 * @version $Id: TestLocalization.java,v 1.2 2003/08/05 19:08:34 jford Exp $
 */

public class TestLocalization extends HeadlessBaseTest
{
    /**
     * Defines the testcase name for JUnit.
     * 
     * @param name   the testcase's name.
     */
    public TestLocalization(String name)
    {
        super(name);
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        junit.awtui.TestRunner.main(new String[] {TestLocalization.class.getName()});
    }

    /**
     */
    public void setup()
    {
        System.out.println("Setup: Testing Localization");
    }

    /**
     * 
     * @return 
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite(TestLocalization.class);
    }


    ///////////////////////////////////////////////////////////////////////////

    public void testGoodTranslation() throws Exception
    {
        Locale locale = null;
        String test = null;

        // Test English translation
        locale = new Locale("en", "US");
        test = CustomLocalization.getString("",locale, "LOGIN_USERNAME");
        System.out.println("Locale [en-US]: LOGIN_USER translation = " + test);

        assertTrue(test.equals("Username:"));

        // Test Polish translation
        locale = new Locale("pl", "");
        test = CustomLocalization.getString("",locale, "LOGIN_TITLE");
        System.out.println("Locale [pl]: LOGIN_TITLE translation = " + test);

        assertTrue(test.equals("Logowanie"));
    
        // Test case when only english translation exists
        locale = new Locale("my", "");
        test = CustomLocalization.getString("",locale, "_TEST_");
        System.out.println("Locale [my]: _TEST_ = " + test);

        assertTrue(test.equals("Do not translate"));

    }

}



