/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
 
/*
 * ViewProcessorFactory.java
 *
 * Created on January 27, 2003, 5:16 PM
 */
package org.apache.jetspeed.portal.portlets.viewprocessor;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

/**
 * Creates the appropriate ViewProcessor to process the template
 *
 * @author  tkuebler
 * @version $Id: ViewProcessorFactory.java,v 1.1.2.2 2003/02/24 21:52:27 tkuebler Exp $
 * @stereotype factory
 * 
 */
public class ViewProcessorFactory
{
    /**
     * Static initialization of the logger for this class
     */    
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ViewProcessorFactory.class.getName());
    
    /** Creates a new instance of ViewProcessorFactory */
    public ViewProcessorFactory()
      {

        // load the type -> processor map
        // this should probably be a turbine service...
      }

    public static ViewProcessor getViewProcessor(String viewType)
      {

        ViewProcessor viewProcessor;

        // figure out the type of portlet based on the map
        // will use properties file or xreg based map later
        // create and return appropriate processor
        // hardcoded for now, will use some config file map in future
        if (viewType.equals("Velocity"))
          {
            logger.info("ViewProcessorFactory - creating Velocity processor");
            viewProcessor = new VelocityViewProcessor();
          }
        else if (viewType.equals("JSP"))
          {
            logger.info("ViewProcessorFactory - creating JSP processor");
            viewProcessor = new JSPViewProcessor();
          }
        else if (viewType.equals("XSL"))
          {
            logger.info("ViewProcessorFactory - creating XSL processor");
            viewProcessor = new XSLViewProcessor();
          }
        else if (viewType.equals("RSS"))
          {
            logger.info("ViewProcessorFactory - creating RSS processor");
            viewProcessor = new RSSViewProcessor();
          }
        else
          {
            logger.error("ViewProcessorFactory - problem figuring out what view processor type you want - " + 
                      viewType);
            logger.error("ViewProcessorFactory - returing a JSP processor");
            viewProcessor = new JSPViewProcessor();
          }

        return viewProcessor;
      }
}
