/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.turbine.util.RunData;

/**
 * RedirectPortlet can be used for menu options that redirect directly 
 * to a URL outside of the portal.
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: RedirectPortlet.java,v 1.1 2004/02/03 19:37:08 taylor Exp $
 */
public class RedirectPortlet extends AbstractInstancePortlet
{           
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RedirectPortlet.class.getName());      
    
    public ConcreteElement getContent(RunData rundata)
    {
        String menuLevel = this.getPortletConfig().getInitParameter("menuLevel");        
        int menus = 1;        
        try 
        {
            if (menuLevel != null)
            {
                menus = Integer.parseInt(menuLevel);
            }
        }
        catch (Exception e)
        {
            logger.error("failed to parse menu level from Redirect Portlet");
        }
        
        // clear the pane ids of all parents so we don't get lock out the portal on return by recursive redirection
        PortletSet set = this.getPortletConfig().getPortletSet();
        int count = 0;
        while (set != null && count <= menus)
        {
            clearState(rundata, set);
            set = set.getPortletConfig().getPortletSet();
            count++;
        }
                     
        String url = this.getPortletConfig().getInitParameter("url");
        rundata.setRedirectURI(url);
        HttpServletRequest request = rundata.getRequest();
        HttpServletResponse response = rundata.getResponse();
        try
        {
            response.sendRedirect(url);
        }
        catch (IOException e)
        {
            String message = "Failed to redirect to " + url;
            logger.error(message, e);
            return new JetspeedClearElement(message);
        }
        return new JetspeedClearElement(url);        
    }
    
    private void clearState(RunData rundata, PortletSet set)
    {
        SessionState state = ((JetspeedRunData)rundata).getPortletSessionState(set.getID());
        state.setAttribute(JetspeedResources.PATH_PANEID_KEY, null);
    }
}
