/*
 *  ====================================================================
 *  The Apache Software License, Version 1.1
 *
 *  Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 *  reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in
 *  the documentation and/or other materials provided with the
 *  distribution.
 *
 *  3. The end-user documentation included with the redistribution,
 *  if any, must include the following acknowledgment:
 *  "This product includes software developed by the
 *  Apache Software Foundation (http://www.apache.org/)."
 *  Alternately, this acknowledgment may appear in the software itself,
 *  if and wherever such third-party acknowledgments normally appear.
 *
 *  4. The names "Apache" and "Apache Software Foundation" and
 *  "Apache Jetspeed" must not be used to endorse or promote products
 *  derived from this software without prior written permission. For
 *  written permission, please contact apache@apache.org.
 *
 *  5. Products derived from this software may not be called "Apache" or
 *  "Apache Jetspeed", nor may "Apache" appear in their name, without
 *  prior written permission of the Apache Software Foundation.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 *  ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 *  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 *  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  ====================================================================
 *
 *  This software consists of voluntary contributions made by many
 *  individuals on behalf of the Apache Software Foundation.  For more
 *  information on the Apache Software Foundation, please see
 *  <http://www.apache.org/>.
 */
package org.apache.jetspeed.portal.portlets;

import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

import org.apache.turbine.util.RunData;
import org.apache.ecs.ConcreteElement;


/**
 * Same as IFramePortlet except that it allows to use basic authentication using current
 * user name and password (or whatever is provided in portlet preferences)
 * 
 * @author <a href="mailto:hoju@visi.com">Jacob Kjome</a>
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: BASICAuthIFramePortlet.java,v 1.2 2003/07/23 19:50:17 morciuch Exp $
 */
public class BASICAuthIFramePortlet extends IFramePortlet
{

    /**
     * Static initialization of the logger for this class
     */    
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BASICAuthIFramePortlet.class.getName());    
    
    private String origSource = null;

    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    /**
     * 
     * @param runData
     * @return 
     */
    public ConcreteElement getContent(RunData runData)
    {
        if (org.apache.jetspeed.util.PortletSessionState.getPortletConfigChanged(this, runData))
        {
            try {
                this.init();
            }
            catch (PortletException pe)
            {
                logger.error("Exception", pe);
            }
        }
        
        setSource(getSource(runData));

        return super.getContent(runData);
    }

    /**
     * 
     * @param runData
     * @return 
     */
    public String getSource(RunData runData)
    {
        String source = origSource;
        if (source == null || source.trim().length() == 0)
        {
            return null;
        }

        int schemeCount = 8;
        int index = source.indexOf("https://");
        if (index == -1)
        {
            schemeCount = 7;
            index = source.indexOf("http://");
        }

        if (index != -1)
        {
            String user = this.getPortletConfig().getInitParameter(USERNAME);
            if (user == null || user.trim().length() == 0)
            {
                user = runData.getUser().getUserName();
            }
            String pass = this.getPortletConfig().getInitParameter(PASSWORD);
            if (pass == null || pass.trim().length() == 0)
            {
                pass = runData.getUser().getPassword();
            }
            String beginStr = source.substring(0, schemeCount);
            String endStr   = source.substring(schemeCount);
            int size = user.length() + pass.length() + source.length() + 2;
            StringBuffer buff = new StringBuffer(size);
            source = buff.append(beginStr).append(user).append(":").append(pass).append("@").append(endStr).toString();
        }
        return source;
    }

    /**
     * 
     * @exception PortletException
     */
    public void init() throws PortletException 
    {
        super.init();
        origSource = getSource();
    }

}
