/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal;

import java.io.File;
import java.util.StringTokenizer;

import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.turbine.services.servlet.TurbineServlet;

/**
 * This default implementation of PortletSkin stores every property
 * as a Map of text properties
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @author <a href="mailto:paulsp@apache.org">Paul Spencer</a>
 * @author <a href="mailto:weaver@apache.org">Scott T. Weaver</a>
 * @version $Id: BasePortletSkin.java,v 1.6 2003/05/09 17:28:30 morciuch Exp $
 */
public class BasePortletSkin extends java.util.HashMap implements PortletSkin
{

    public String name = null;
    private CapabilityMap cm;
    private static final String[] VALID_EXTENSIONS = new String[] { "gif", "jpg", "png" };

    /**
     * Returns the name of this color scheme
     * @return the color scheme name
     */
    public String getName()
    {
        return this.name;
    }

    /** Sets the name of this Skin
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * Returns the color to use for displaying the portlet text
     * @return the text color value in HTML format (#RRGGBB)
     */
    public String getTextColor()
    {
        return (String)get(TEXT_COLOR);
    }

    /**
     * Sets the color to use for displaying the portlet text
     * @param color the text color value in HTML format (#RRGGBB)
     */
    public void setTextColor(String color)
    {
        if (color!=null)
        {
            put(TEXT_COLOR,color);
        }
    }

    /**
     * Returns the color to use for displaying the portlet background
     * @return the text color value in HTML format (#RRGGBB)
     */
    public String getBackgroundColor()
    {
        return (String)get(BACKGROUND_COLOR);
    }

    /**
     * Sets the color to use for displaying the portlet background
     * @param backgroundColor the background color value in HTML format (#RRGGBB)
     */
    public void setBackgroundColor(String color)
    {
        if (color!=null)
        {
            put(BACKGROUND_COLOR,color);
        }
    }


    /**
     * Returns the color to use for displaying the portlet title text
     * @return the text color value in HTML format (#RRGGBB)
     */
    public String getTitleTextColor()
    {
        return (String)get(TITLE_TEXT_COLOR);
    }


    /**
     * Sets the color to use for displaying the portlet title text
     * @param titleColor the title color value in HTML format (#RRGGBB)
     */
    public void setTitleTextColor(String color)
    {
        if (color!=null)
        {
            put(TITLE_TEXT_COLOR,color);
        }
    }

    /**
     * Returns the color to use for displaying the portlet title background
     * @return the background color value in HTML format (#RRGGBB)
     */
    public String getTitleBackgroundColor()
    {
        return (String)get(TITLE_BACKGROUND_COLOR);
    }

    /**
     * Sets the color to use for displaying the portlet title background
     * @param titleColor the title color value in HTML format (#RRGGBB)
     */
    public void setTitleBackgroundColor(String color)
    {
        if (color!=null)
        {
            put(TITLE_BACKGROUND_COLOR,color);
        }
    }

    /**
     * Returns the color to use for displaying an highlighted text
     * @return the text color value in HTML format (#RRGGBB)
     */
    public String getHighlightTextColor()
    {
        return (String)get(HIGHLIGHT_TEXT_COLOR);
    }

    /**
     * Sets the color to use for displaying an highlighted text
     * @param titleColor a color value in HTML format (#RRGGBB)
     */
    public void setHighlightTextColor(String color)
    {
        if (color!=null)
        {
            put(HIGHLIGHT_TEXT_COLOR,color);
        }
    }

    /**
     * Returns the color to use for displaying an highlighted background
     * @return the background color value in HTML format (#RRGGBB)
     */
    public String getHighlightBackgroundColor()
    {
        return (String)get(HIGHLIGHT_BACKGROUND_COLOR);
    }

    /**
     * Sets the color to use for displaying an highlighted background
     * @param titleColor the title color value in HTML format (#RRGGBB)
     */
    public void setHighlightBackgroundColor(String color)
    {
        if (color!=null)
        {
            put(HIGHLIGHT_BACKGROUND_COLOR,color);
        }
    }

    /**
     * Returns the CSS class to use for the portlet overall
     * @return the CSS class to use (PortletStyleClass)
     */
    public String getPortletStyleClass()
    {
        return (String)get(PORTLET_STYLE_CLASS);
    }

    /**
     * Sets the CSS class to use for the portlet overall
     * @param portletStyleClass the new class to be used
     */
    public void setPortletStyleClass(String portletStyleClass)
    {
        if (portletStyleClass!=null)
        {
            put(PORTLET_STYLE_CLASS,portletStyleClass);
        }
    }

    /**
     * Returns the CSS class to use for the portlet title
     * @return the CSS class to use (TitleStyleClass)
     */
    public String getTitleStyleClass()
    {
        return (String)get(TITLE_STYLE_CLASS);
    }

    /**
     * Sets the CSS class to use for the portlet title
     * @param titleStyleClass the new class to be used
     */
    public void setTitleStyleClass(String titleStyleClass)
    {
        if (titleStyleClass!=null)
        {
            put(TITLE_STYLE_CLASS,titleStyleClass);
        }
    }

    /**
     * Returns the CSS class to use for the portlet content
     * @return the CSS class to use (ContentStyleClass)
     */
    public String getContentStyleClass()
    {
        return (String)get(CONTENT_STYLE_CLASS);
    }

    /**
     * Sets the CSS class to use for the portlet content
     * @param contentStyleClass the new class to be used
     */
    public void setContentStyleClass(String contentStyleClass)
    {
        if (contentStyleClass!=null)
        {
            put(CONTENT_STYLE_CLASS,contentStyleClass);
        }
    }

    /**
     * Returns the CSS class to use overall for the tabbed control
     * @return the CSS class to use (TabStyleClass)
     */
    public String getTabStyleClass()
    {
        return (String)get(TAB_STYLE_CLASS);
    }

    /**
     * Sets the CSS class to use for overall for the tabbed control
     * @param tabStyleClass the new class to be used
     */
    public void setTabStyleClass(String tabStyleClass)
    {
        if (tabStyleClass!=null)
        {
            put(TAB_STYLE_CLASS,tabStyleClass);
        }
    }

    /**
     * Returns the CSS class to use on the title of the tabbed control
     * @return the CSS class to use (TabTitleStyleClass)
     */
    public String getTabTitleStyleClass()
    {
        return (String)get(TAB_TITLE_STYLE_CLASS);
    }

    /**
     * Sets the CSS class to use on the title of the tabbed control
     * @param tabTitleStyleClass the new class to be used
     */
    public void setTabTitleStyleClass(String tabTitleStyleClass)
    {
        if (tabTitleStyleClass!=null)
        {
            put(TAB_TITLE_STYLE_CLASS,tabTitleStyleClass);
        }
    }

    /**
     * Returns the CSS class to use on the control of the tabbed control
     * @return the CSS class to use (TabContentStyleClass)
     */
    public String getTabContentStyleClass()
    {
        return (String)get(TAB_CONTENT_STYLE_CLASS);
    }

    /**
     * Sets the CSS class to use on the control of the tabbed control
     * @param tabContentStyleClass the new class to be used
     */
    public void setTabContentStyleClass(String tabContentStyleClass)
    {
        if (tabContentStyleClass!=null)
        {
            put(TAB_CONTENT_STYLE_CLASS,tabContentStyleClass);
        }
    }

    /**
     * Returns the CSS class to use on the control of the Highlighted title tab or menu item
     * @return the CSS class to use (HighlightTitleStyleClass)
     */
    public String getHighlightTitleStyleClass()
    {
        return (String)get(HIGHLIGHT_TITLE_STYLE_CLASS);
    }

    /**
     * Sets the CSS class to use on the control of the Highlighted title tab or menu item
     * @param highlightTitleStyleClass the new class to be used
     */
    public void setHighlightTitleStyleClass(String highlightTitleStyleClass)
    {
        if (highlightTitleStyleClass!=null)
        {
            put(HIGHLIGHT_TITLE_STYLE_CLASS, highlightTitleStyleClass);
        }
    }

    /**
     * Returns the CSS class to use for the controller overall
     * @return the CSS class to use (ControllerStyleClass)
     */
    public String getControllerStyleClass()
    {
        return (String)get(CONTROLLER_STYLE_CLASS);
    }

    /**
     * Sets the CSS class to use for the controller overall
     * @param controllerStyleClass the new class to be used
     */
    public void setControllerStyleClass(String controllerStyleClass)
    {
        if (controllerStyleClass!=null)
        {
            put(CONTROLLER_STYLE_CLASS,controllerStyleClass);
        }
    }

    /**
     * Returns the CSS class to use for the global skin rendering
     * @see org.apache.jetspeed.portal.PortletSkin#getPortletSkinClass()
     */
    public String getPortletSkinClass()
    {
        return (String)get(PORTLET_SKIN_CLASS);
    }

    /**
     * Sets the CSS class to use for the global skin rendering
     * @param portletSkinClass the new class to be used
     */
    public void setPortletSkinClass(String portletSkinClass)
    {
        if (portletSkinClass!=null)
        {
            put(PORTLET_SKIN_CLASS,portletSkinClass);
        }
    }

    /**
     * @see org.apache.jetspeed.portal.PortletSkin#getImage(String, String)
     */
    public String getImage(String name, String dftPath)
    {

        if (containsKey("image-" + name))
        {
            return buildMediaTypeSpecificPath((String) get("image-" + name));
        }

        String path = imageDiscovery(name);
        if (path != null)
        {
            return path;
        }
        else
        {
            return dftPath;
        }
    }


    /**
    * This allows the PortalToolKit to make the PortletSkin aware
    * of the current user-agents's capabilities
    * @param CapabilityMap cm Current capaibilities of the user-agent
    * @author <a href="mailto:weaver@apache.org">Scott T. Weaver</a>
    */
    public void setCapabilityMap(CapabilityMap cm)
    {
        this.cm = cm;
    }

    /**
     * builds a media type specific path for the relative path provided
     */
    private String buildMediaTypeSpecificPath(String relativePath)
    {
        String path = "images/" + cm.getPreferredMediaType() + "/skins/" + relativePath;
        return path;
    }

    /**
     * builds a media type specific path using this skin's name.
     */
    private String buildMediaTypeSpecificPath()
    {
        return buildMediaTypeSpecificPath(name);
    }

    private  String imageDiscovery(String imageName)
    {
        String imagePathes = (String) get("image.paths");
        boolean hasExtension = hasImageExtension(imageName);
        String fullPath = null;
        if (imagePathes != null)
        {
            StringTokenizer tokenizer = new StringTokenizer(imagePathes, ",");
            while (tokenizer.hasMoreTokens())
            {
                fullPath =
                    buildValidImage(
                        buildMediaTypeSpecificPath(tokenizer.nextToken()),
                        imageName,
                        hasExtension);
                if (fullPath != null)
                {
                    return fullPath;
                }
            }
        }

        if (fullPath == null)
        {
            String skinBasedPath = buildMediaTypeSpecificPath();
            fullPath = buildValidImage(skinBasedPath, imageName, hasExtension);
        }
        return fullPath;
    }

    /**
     * Does the path contain a valid image extension?
     */
    private boolean hasImageExtension(String path)
    {
        return (path.indexOf(".gif") > -1)
            || (path.indexOf(".jpg") > -1)
            || (path.indexOf(".png") > -1);
    }

    /**
     * makes every attempt to locate a valid image based on the combination
     * of an absoulte path and relative path or name.  The relPath may pr may not
     * contain a valid image extension (.gif, .png, .jpg).
     */
    private String buildValidImage(String absPath, String relPath, boolean hasExtension)
    {
        String path = null;

        if (hasExtension)
        {
            path = absPath + "/" + relPath;
            if (fileExists(path))
            {
                return path;
            }
        }
        else
        {
            for (int i = 0; i < VALID_EXTENSIONS.length; i++)
            {
                path = absPath + "/" + relPath + "." + VALID_EXTENSIONS[i];
                if (fileExists(path))
                {
                    return path;
                }
            }
        }

        return null;
    }

    /**
     * Does this <code>path</code> exist in the current file system.
     */
    private boolean fileExists(String path)
    {
        File testPath = null;
        testPath = new File(TurbineServlet.getRealPath(path));
        if (testPath.exists())
        {
            testPath = null;
            return true;
        }
        else
        {
            testPath = null;
            return false;
        }
    }

}
