/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.actions.portlets.security;


/**
 * This class contains all the common constants used between data entry forms and browsers and actions
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: SecurityConstants.java,v 1.5 2004/01/06 20:26:16 morciuch Exp $
 */
public class SecurityConstants
{
    // msg id - for error or information messages on data entry forms
    public static final String PARAM_MSGID = "msgid";
    // msg - the informational or form message in a form
    public static final String PARAM_MSG = "msg";
    // unique entity id - parameter passed between browser forms and update forms
    public static final String PARAM_ENTITY_ID = "entityid";
    // username parameter
    public static final String PARAM_USERNAME = "username";

    // mode parameter
    public static final String PARAM_MODE = "mode";
    // update mode parameter
    public static final String PARAM_MODE_UPDATE = "update";
    // delete mode parameter
    public static final String PARAM_MODE_DELETE = "delete";
    // insert mode parameter
    public static final String PARAM_MODE_INSERT = "insert";

    //
    // Context Constants
    //
    public static final String CONTEXT_USER = "user";
    public static final String CONTEXT_USERS = "users";
    public static final String CONTEXT_ROLE = "role";
    public static final String CONTEXT_ROLES = "roles";
    public static final String CONTEXT_PERMISSION = "permission";
    public static final String CONTEXT_PERMISSIONS = "permissions";
    public static final String CONTEXT_GROUP = "group";
    public static final String CONTEXT_GROUPS = "groups";
    public static final String CONTEXT_SELECTED = "selected";
    public static final String CONTEXT_ROLES_SELECTED = "roles_selected";
    public static final String CONTEXT_GROUPS_SELECTED = "groups_selected";
    public static final String CONTEXT_GROUPS_ROLES = "userGroupRoles";

    // user browser pane id
    public static final String PANEID_USER_BROWSER = "UserBrowser";
    // user form pane id
    public static final String PANEID_USER_UPDATE = "UserForm";
    // role browser pane id
    public static final String PANEID_ROLE_BROWSER = "RoleBrowser";
    // role form pane id
    public static final String PANEID_ROLE_UPDATE = "RoleForm";
    // permission browser pane id
    public static final String PANEID_PERMISSION_BROWSER = "PermissionBrowser";
    // permission form pane id
    public static final String PANEID_PERMISSION_UPDATE = "PermissionForm";
    // group browser pane id
    public static final String PANEID_GROUP_BROWSER = "GroupBrowser";
    // group form pane id
    public static final String PANEID_GROUP_UPDATE = "GroupForm";
    // user role form pane id
    public static final String PANEID_USERROLE_UPDATE = "UserRoleForm";
    // role permission form pane id
    public static final String PANEID_ROLEPERMISSION_UPDATE = "PermissionBrowser";

    public static final String PANE_NAME = "js_panename";

    //
    // Informational and Error Messages for Security Forms
    ///
    public static final String MESSAGES[] =
    {
        "Database Update Failure. Please report this error to your Database Administrator.",
        "Database Delete Failure. Please report this error to your Database Administrator.",
        "Invalid Entity Name. Please enter a valid entity name.",
        "Entity Name Already Exists. Please choose another unique, identifying name.",
        "Deletion not allowed. You are trying to delete the currently logged on user.",
        "Missing Parameter. Cannot process Security form."
    };
    //
    // indexes into messages
    //
    public static final int MID_UPDATE_FAILED = 0;
    public static final int MID_DELETE_FAILED = 1;
    public static final int MID_INVALID_ENTITY_NAME = 2;
    public static final int MID_ENTITY_ALREADY_EXISTS = 3;
    public static final int MID_CANT_DELETE_CURRENT = 4;
    public static final int MID_MISSING_PARAMETER = 5;

};
