/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.jetspeed.om.registry.MediaTypeRegistry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/**
 * This action extends the RegistryBrowseAction to provide filtering for portlets
 * and add extra information into the context 
 * 
 * @author <a href="mailto:jford@apache.org">Jeremy Ford</a>
 * @version $Id: PortletBrowseAction.java,v 1.1 2003/11/03 05:25:31 jford Exp $
 */
public class PortletBrowseAction extends RegistryBrowseAction
{
    /**
    * Subclasses must override this method to provide default behavior
    * for the portlet action
    */
    /**
    * Build the normal state content for this portlet.
    *
    * @param portlet The velocity-based portlet that is being built.
    * @param context The velocity context for this request.
    * @param rundata The turbine rundata context for this request.
    */
    protected void buildNormalContext(
        Portlet portlet,
        Context context,
        RunData rundata)
    {
        super.buildNormalContext(portlet, context, rundata);

        List portlets =
            (List) PortletSessionState.getAttribute(portlet, rundata, RESULTS);

        List categories = PortletFilter.buildCategoryList(portlets);
        context.put("categories", categories);

        MediaTypeRegistry mediaTypeReg =
            (MediaTypeRegistry) Registry.get(Registry.MEDIA_TYPE);

        ArrayList collection = new ArrayList();
        Iterator iter = mediaTypeReg.listEntryNames();
        while (iter.hasNext())
        {
            collection.add(iter.next());
        }

        context.put("media_types", collection);

        context.put("parents", PortletFilter.buildParentList(portlets));
    }

    /**
     * Filter portlets by using the PortletFilter helper class
     * 
     * @see org.apache.jetspeed.modules.actions.portlets.RegistryBrowseAction#filter(java.util.List, java.lang.String[], java.lang.String[])
     */
    protected List filter(List entries, String[] fields, String[] values)
    {
        return PortletFilter.filterPortlets(entries, fields, values);
    }
}
