/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/**
 * This action enables to update the media entries
 *
 * @author <a href="mailto:caius1440@hotmail.com">Jeremy Ford</a>
 * @version $Id: MediaUpdateAction.java,v 1.1 2003/05/02 19:23:48 taylor Exp $
 */
public class MediaUpdateAction extends RegistryUpdateAction
{
    private static final String MEDIA_UPDATE_PANE = "MediaForm";
    
    public MediaUpdateAction()
    {
        registryEntryName = "media_type_name";
        registry = Registry.MEDIA_TYPE;
        pane = MEDIA_UPDATE_PANE;
    }

    /**
     * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet, org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
     */
    protected void buildNormalContext(
        VelocityPortlet portlet,
        Context context,
        RunData rundata)
        throws Exception
    {
        super.buildNormalContext(portlet, context, rundata);
                
        String mode =
            rundata.getParameters().getString(SecurityConstants.PARAM_MODE);
        
        if (mode != null
            && (mode.equals(SecurityConstants.PARAM_MODE_DELETE)
                || mode.equals(SecurityConstants.PARAM_MODE_UPDATE)))
        {
            String mediaTypeName =
                rundata.getParameters().getString(registryEntryName);
            MediaTypeEntry mediaEntry =
                (MediaTypeEntry) Registry.getEntry(
                    registry,mediaTypeName);
            context.put("entry", mediaEntry);
        }
    }
    
    /** 
     * @see org.apache.jetspeed.modules.actions.portlets.RegistryUpdateAction#updateRegistryEntry(org.apache.turbine.util.RunData, org.apache.jetspeed.om.registry.RegistryEntry)
     */
    protected void updateRegistryEntry(RunData rundata, RegistryEntry registryEntry) throws Exception
    {
        super.updateRegistryEntry(rundata, registryEntry);
        
        updateMediaTypeEntry(rundata, (MediaTypeEntry) registryEntry);
    }

    /**
     * @param rundata
     * @param mediaTypeName
     */
    protected void updateMediaTypeEntry(
        RunData rundata,
        MediaTypeEntry mediaTypeEntry)
    {
        String charSet = rundata.getParameters().getString("charset");
        String mimeType = rundata.getParameters().getString("mime_type");

        if(hasChanged(mediaTypeEntry.getCharacterSet(), charSet))
        {
            mediaTypeEntry.setCharacterSet(charSet);
        }
        if(hasChanged(mediaTypeEntry.getMimeType(), mimeType))
        {
            mediaTypeEntry.setMimeType(mimeType);
        }
    }

    /**
      * Populates the user's temp storage with form data
      * @param rundata The turbine rundata context for this request.
      */
    protected void resetForm(RunData rundata)
    {
        super.resetForm(rundata);
        String charSet = rundata.getParameters().getString("charset");
        String mimeType = rundata.getParameters().getString("mime_type");
        
        rundata.getUser().setTemp("charset", charSet);
        rundata.getUser().setTemp("mime_type", mimeType);
    }
    
    /**
     * Clears the temporary storage of any data that was used
     * @param rundata The turbine rundata context for this request.
     */
    protected void clearUserData(RunData rundata)
    {
        super.clearUserData(rundata);
        rundata.getUser().removeTemp("charset");
        rundata.getUser().removeTemp("mime_type");
    }
}
