/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.actions.portlets;

// Jetspeed stuff
import org.apache.jetspeed.portal.Portlet;

// Turbine stuff

import org.apache.turbine.util.RunData;

import org.apache.velocity.context.Context;

/**
 * An abstract action class to build JspPortlet actions.
 * 
 * <p>Don't call it from the URL, the Portlet and the Action are automatically
 * associated through the registry PortletName
 *  <p>
 *  <strong>NOTE:</strong>This supports the pre-MVC style of template based 
 *   portlet development and is supplied for backward compatibility.   It is
 *  suggested you  use a combination of 
 *  @see org.apache.jetspeed.portal.portlets.GenericMVCPortlet along with
 *  subclassing @see org.apache.jetspeed.portal.portlets.GenericMVCAction
 *  for future portlet development.
 *  </p>
 * 
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a>
 * @author <a href="mailto:sweaver@rippe.com">Scott Weaver</a>
 *
 * @version $Id: JspPortletAction.java,v 1.6 2003/03/24 00:56:56 weaver Exp $
 */
public abstract class JspPortletAction extends GenericMVCAction
{

    /**
    * @see org.apache.jetspeed.portal.portlets.mvc.PortletAction#buildConfigureContext(Portlet, Context, RunData)     
    */
    protected void buildConfigureContext(Portlet portlet, Context context, RunData rundata)
        throws Exception
    {

        buildConfigureContext(portlet, rundata);
        if (rundata.getRequest().getAttribute("_" + portlet.getID() + "_noConfigureContext")
            != null)
        {
            super.buildConfigureContext(portlet, context, rundata);
        }
    }

    /** 
      * Kept for backward compatibility.  New classes should use 
     * the method signatures build*(Portlet, Context, RunData)
     * If you override this method <b>DO NOT</b> call super.buildConfigureContext().
     * <br>
     * Subclasses should override this method if they wish to
     * provide their own customization behavior.
     * Default is to use Portal base customizer action
     */
    protected void buildConfigureContext(Portlet portlet, RunData rundata) throws Exception
    {

        // STW: backward compatibility bootstrap flag
        rundata.getRequest().setAttribute("_" + portlet.getID() + "_noConfigureContext", " ");
    }

    /**
     * @see org.apache.jetspeed.portal.portlets.mvc.PortletAction#buildMaximizedContext(Portlet, Context, RunData)
     */
    protected void buildMaximizedContext(Portlet portlet, Context context, RunData rundata)
        throws Exception
    {
        buildMaximizedContext(portlet, rundata);
        if (rundata.getRequest().getAttribute("_" + portlet.getID() + "_noMaximizedContext")
            != null)
        {
            super.buildMaximizedContext(portlet, context, rundata);
        }
    }

    /** 
     * Kept for backward compatibility.  New classes should use 
     * the method signatures build*(Portlet, Context, RunData)
     * If you override this method <b>DO NOT</b> call super.buildMaximizedContext().
     * <br>
     * Subclasses should override this method if they wish to
     * build specific content when maximized. Default behavior is
     * to do the same as normal content.<br>     
     */
    protected void buildMaximizedContext(Portlet portlet, RunData rundata) throws Exception
    {
        // STW: backward compatibility bootstrap flag
        rundata.getRequest().setAttribute("_" + portlet.getID() + "_noMaximizedContext", " ");
    }

    /**
     * @see org.apache.jetspeed.portal.portlets.mvc.PortletAction#buildNormalContext(Portlet, Context, RunData)
     */
    protected void buildNormalContext(Portlet portlet, Context context, RunData data)
        throws Exception
    {
        buildNormalContext(portlet, data);
    }

    /** 
     * Subclasses must override this method to provide default behavior 
     * for the portlet action
     */
    protected abstract void buildNormalContext(Portlet portlet, RunData rundata) throws Exception;
	
	/**
	 * You should use one of PortletAction.setTemplate() methods
	 * @deprecated
	 */
    public void setTemplate(RunData data, Portlet portlet, String template)
    
    {
    	if(template != null)
    	{
        	super.setTemplate(data, template, true);
    	}
    	else
    	{
    		super.resetTemplate(data);
    	}
    }

}
