/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.modules.actions.controllers;

import java.util.List;
import java.util.Map;

import javax.servlet.ServletRequest;

import org.apache.jetspeed.om.profile.psml.PsmlEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.template.JetspeedTool;
import org.apache.jetspeed.util.template.JspTemplate;
import org.apache.jetspeed.util.StringUtils;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/**
 * XMultiColumnControllerAction
 *
 * @author <a href="mailto:junyang@cisco.com">Jun Yang</a>
 * @version $Id: XMultiColumnControllerAction.java,v 1.1 2003/11/02 20:07:16 taylor Exp $
 */
public class XMultiColumnControllerAction extends MultiColumnControllerAction
{
    protected void buildCustomizeContext(
        PortletController controller,
        Context context,
        RunData rundata
    )
    {
        super.buildCustomizeContext(controller, context, rundata);
        context.put("template", "x-multicolumn-customize.vm");
        context.put("action", "controllers.XMultiColumnControllerAction");

        context.put("includedContent", new JspTemplate(rundata, "/controllers/html/x-multicolumn-customize.jsp"));
        ServletRequest request = rundata.getRequest();
        request.setAttribute("jspContext", context);

        // debug
        Object[] columns = (Object[]) context.get("portlets");
        Map portletTitleMap = (Map) context.get("titles");
        for (int i = 0; i < columns.length; i++)
        {
            List portletList = (List) columns[i];
            for (int j = 0; j < portletList.size(); j++)
            {
                PsmlEntry entry = (PsmlEntry) portletList.get(j);
                String portletTitle = (String) portletTitleMap.get(entry.getId());
                String portletSkinName = entry.getSkin() == null ? "-- Default --" : entry.getSkin().getName();
                String portletSecurityId =
                    entry.getSecurityRef() == null ?
                    "-- Default --" :
                    entry.getSecurityRef().getParent();
                String controlListBox =
                (entry.getControl() != null && entry.getControl().getName() != null) ?
                    JetspeedTool.getPortletParameter(rundata, 
                                                     (Portlet) rundata.getUser().getTemp("customizer"),
                                                      "control", entry.getControl().getName()) :
                    JetspeedTool.getPortletParameter(rundata, (Portlet) rundata.getUser().getTemp("customizer"), "control");
                controlListBox = controlListBox.substring(12);
                controlListBox = controlListBox.replace('\n', ' ');
                controlListBox = controlListBox.replace('\r', ' ');
                int z = 0;
            }
        }
    }
    
    public void doSave(RunData data, Context context)
    {
        applyModelChanges(data, context);
        super.doSave(data, context);
    }

    public void doDelete(RunData data, Context context)
    {
        applyModelChanges(data, context);
        super.doDelete(data, context);
    }

    public void doControl(RunData data, Context context)
    {
        applyModelChanges(data, context);
        super.doControl(data, context);
    }

    protected void applyModelChanges(RunData data, Context context)
    {
        ServletRequest request = data.getRequest();
        String[] modelChangeList = request.getParameterValues("modelChangeList");
        if (modelChangeList != null)
        {
            String[] moves = StringUtils.stringToArray(modelChangeList[0], ";");

            SessionState customizationState = ((JetspeedRunData) data).getPageSessionState();
            List[] columns = (List[]) customizationState.getAttribute("customize-columns");

            for (int i = 0; i < moves.length; i++)
            {
                String[] values = StringUtils.stringToArray(moves[i], ",");
                int originCol = Integer.parseInt(values[0]);
                int originRow = Integer.parseInt(values[1]);
                int destCol = Integer.parseInt(values[2]);
                int destRow = Integer.parseInt(values[3]);

                Object portletEntry = columns[originCol].get(originRow);
                columns[originCol].remove(originRow);
                columns[destCol].add(destRow, portletEntry);
            }
        }
    }
}    

