/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.daemon;


/**
A simple interface to create Daemons within Jetspeed.  These are basically 
threads that get work done to facilitate content serving.

@author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
@version $Id: Daemon.java,v 1.8 2001/03/07 06:42:48 taylor Exp $
*/
public interface Daemon extends Runnable {

    public final static int STATUS_UNKNOWN          = 0;
    public final static int STATUS_NOT_PROCESSED    = 1;
    public final static int STATUS_PROCESSED        = 2;
    public final static int STATUS_PROCESSING       = 3;
    public final static int STATUS_NOT_STARTED      = 4;
    public final static int STATUS_STARTED          = 5;

    /**
    The result for this daemon is not yet known.
    */
    public final static int RESULT_UNKNOWN          = 0;

    /**
    A daemon has processed and it was successful
    */
    public final static int RESULT_SUCCESS          = 1;

    /**
    A daemon has processed but it has failed
    */
    public final static int RESULT_FAILED           = 2;

    /**
    A daemon is processing so its result is not yet known
    */
    public final static int RESULT_PROCESSING       = 3;
    
    /**
    Initialize this daemon providing configuration data.
    */
    public void init(DaemonConfig config, DaemonEntry entry);

    /**
    Require that Daemons have a getter for the DaemonConfig
    */
    public DaemonConfig getDaemonConfig();

    /**
    Report on the status of this daemon.  Should be of STATUS_NOT_PROCESSED, 
    STATUS_PROCESSED, or STATUS_PROCESSING 
    */
    public int getStatus();

    /**
    Force the status on this Daemon
    */
    public void setStatus(int status);
    
    /**
    Get the entry for this daemon.
    */
    public DaemonEntry getDaemonEntry();

    /**
    <p>
    Get the result of this daemons processing.  All Daemon implementations 
    are responsible for defining this.
    </p>
    
    <p>
    The default for this should be RESULT_UNKNOWN.  This usually means that
    this daemon has never been called for processing.  
    </p>
    */
    public int getResult();

    /**
    Force the result of this Daemon
    */
    public void setResult( int result );

    /**
    Provided so that a Daemon can provide a message to users.  Null if it has
    nothing to give to the user.
    */
    public String getMessage();
}

