/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.cache.disk;
 
import java.io.*;

/**
Interface for a DiskCacheEntry.

@author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
@version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
*/
public interface DiskCacheEntry {

    /**
    Get the URL that was cached.
    
    @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public String getURL();
    
    /**
    Get the original URL this came from
    
    @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public String getSourceURL();

    /**
    Get a File which is representative of this item in the cache
    @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    @deprecated 
    @use We should use getInputStream (preferred) or getData instead
    */
    public File getFile();

    /**
    Get the contents/data of this URL
    
    @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public String getData() throws IOException;

    /**
    Get an InputStream for this Entry.

    @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public InputStream getInputStream() throws IOException;

    /**
    Get a Reader for this Entry.
    It should take into account the character encoding.

    @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public Reader getReader() throws IOException;
    
    /**
    Get a Writer to update  this Entry.
    It should take into account the character encoding.
	It will throw an exception if the entry is not writable

    @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public Writer getWriter() throws IOException;
    
    /**
    Get  the lastModified date of this  DiskCacheEntry
    @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public long getLastModified();

    /**
    Set  the lastModified date of this  DiskCacheEntry
    @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public void setLastModified(long time);

    /**
    Get the expiration time of this  DiskCacheEntry
    @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public long getExpirationTime();

    /**
    Set the expiration time of this  DiskCacheEntry
    @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public void setExpirationTime(long time);

    /**
    Test if the entry is expired
    @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public boolean hasExpired();

    /**
    Test if the entry is a Local (fake) disk cache entry
    @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
    @version $Id: DiskCacheEntry.java,v 1.8 2001/05/29 18:47:19 sgala Exp $
    */
    public boolean isLocal();

}

