/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.Portlet;

/**
 ** A <CODE>WindowEvent</CODE> is sent by a portlet window whenever the
 ** user or the portal interacts with its controls.
 **
 ** @see   WindowListener
 ** @see   WindowAdapter
 **
 ** @author   <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 **/

public interface WindowEvent extends Event
{
    /**
     ** Event identifier indicating that a portlet window will be
     ** detached.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be detached from the rest of the portlet page.
     **/

    public final static int WINDOW_DETACHED = 1001;

    /**
     ** Event identifier indicating that a portlet window will be
     ** moved.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be moved to a different location on the
     ** page.
     **/

//    public final static int WINDOW_MOVING = 1002;

    /**
     ** Event identifier indicating that a portlet window will be
     ** resized.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be resized.
     **/

//    public final static int WINDOW_RESIZING = 1003;

    /**
     ** Event identifier indicating that a portlet window will be
     ** maximized.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be maximized.
     **/

    public final static int WINDOW_MAXIMIZED = 1004;

    /**
     ** Event identifier indicating that a portlet window will be
     ** minimized.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be minimized.
     **/

    public final static int WINDOW_MINIMIZED = 1005;

    /**
     ** Event identifier indicating that a portlet window will be
     ** restored.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be restored to its previous size.
     **/

    public final static int WINDOW_RESTORED = 1006;

    /**
     ** Event identifier indicating that a portlet window is
     ** closed.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be closed.
     **/

    public final static int WINDOW_CLOSED = 1007;
}