/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet;

import java.util.Locale;

/**
 * The <CODE>PortletTitle</CODE> interface has to be implemented if
 * a portlet wants to support client, device, and/or user dependent
 * titles. An instance of the implementation can be set in the portlet
 * descriptor of the portlet, otherwise the portlet container will pick the
 * title from the portlet configuration.
 * 
 * @author <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 * @see PortletWindow
 */
public interface PortletTitle
{
    /**
     ** Called by the portlet container to retrieve the text of the
     ** portlet title. The given locale, client, and session can but
     ** don't have to be considered all at once. Examples are
     **
     ** <UL>
     ** <LI>language-dependant titles for multi-lingual portals
     ** <LI>shorter titles for WAP phones
     ** <LI>the number of messages in a mailbox portlet
     ** </UL>
     **
     ** The session may be <CODE>null</CODE>, if the user is not logged 
     ** in. If returning <CODE>null</CODE> the portlet container shows
     ** the static title from the portlet configuration.
     **
     ** @param   locale
     **          the locale
     ** @param   client
     **          the client
     ** @param   session
     **          the portlet session
     ** @param   context
     **          the portlet context
     **
     ** @return   the text of the portlet title
     **/

    public String getText (Locale locale,
                           Client client,
                           PortletSession session,
                           PortletContext context);
}
