/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet;

import java.io.PrintWriter;
import java.io.IOException;

import org.apache.jetspeed.portlet.event.ActionListener;

/**
 ** The <CODE>PortletResponse</CODE> interface represents the response
 ** sent to the client device.
 **
 ** <P>
 ** It is up to the portlet container to enhance, extend, or modify
 ** the response as required before it is actually sent to the client
 ** device.
 **
 ** @see   PortletRequest
 **
 ** @author   <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 **/

public interface PortletResponse
{
    /**
     * Returns the writer object that can be used to contribute
     * markup to the portlet response.
     * 
     * <P>
     * It is important to note that the markup generated by the
     * portlet is either a full document or just a fragment of the
     * markup. A corresponding setting in the deployment descriptor
     * has to be made.
     * </P>
     * 
     * @return the print writer
     * @exception IOException
     *                   if the I/O operation fails
     */
    public PrintWriter getWriter () throws IOException;

    /**
     * Creates a portlet URI for the given portlet mode. The returned URI
     * can be further extended by adding portlet-specific parameters
     * and by attaching actions. Also, the portlet window will stay in the
     * same state as before.
     * 
     * @param mode
     *               the portlet mode
     * @return a portlet URI
     */
    public PortletURI createURI (Portlet.Mode mode);

    /**
     * Creates a portlet URI for the given portlet mode and given portlet
     * window state. The returned URI can be further extended
     * by adding portlet-specific parameters and by attaching actions.
     * 
     * @param mode
     *               the portlet mode
     * @param state
     *               the portlet window state
     * @return a portlet URI
     */
    public PortletURI createURI (Portlet.Mode mode, PortletWindow.State state);

    /**
     * <P>
     * Returns the encoded URI of the resource at the given path.
     * Encoding may include prefixing, conversion to absolute URL, etc.
     * </P>
     * <P>
     * To generate unprotected URI's like an image use the direct
     * path inside of you portlet (e.g. /myportlet/myimage.gif).
     * Otherwise, to generate protected URI's like an property file use the
     * path inside of your portlet prefixed with /portlet-inf/
     * (e.g. /portlet-inf/myportlet/myportlet.jsp)
     * </P>
     * 
     * @param path
     *               the path to the resource
     * @return the resource URI as string
     */
    public String encodeURI (String path);

    /**
     * Maps the given string value into this portlet's namespace.
     * Should be applied to every variable or name used in the
     * output stream. For example, an parameter used in forms,
     * a function name in javascript.
     * 
     * @param aValue
     *               the name to be mapped
     * @return the mapped name
     */
    public String encodeNamespace (String aValue);
}


