/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.conf;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Element {
    private String name;
    private Hashtable attributes;
    private Vector children;
    private String data;
    private String comment;
    private Element parent;

    public Element() {
        this("", null);
    }

    public Element(String s, Element parent) {
        this.parent = parent;
        this.name = new String(s);
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.data = new String();
        this.comment = new String();
    }

    public void addChild(Element element) throws NullPointerException {
        if (element == null) {
            throw new NullPointerException("Child cannot be null");
        }
        this.children.addElement(element);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void clearChildren() {
        this.children.removeAllElements();
    }

    public void clearComment() {
        this.comment = new String();
    }

    public void clearData() {
        this.data = new String();
    }

    public int countChildren() {
        return this.children.size();
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAttributeValue(String s) {
        return (String)this.attributes.get(s);
    }

    public Element getChild(String name) {
        Enumeration enumeration = this.getChildren(name);
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        return (Element)enumeration.nextElement();
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public Enumeration getChildren(String s) {
        Vector<Element> vector = new Vector<Element>();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            if (!element.getName().equals(s)) continue;
            vector.addElement(element);
        }
        return vector.elements();
    }

    public String getComment() {
        return this.comment;
    }

    public String getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public Element getParent() {
        return this.parent;
    }

    public boolean hasAttributes() {
        return this.attributes.isEmpty() ^ true;
    }

    public boolean hasChildren() {
        return this.children.isEmpty() ^ true;
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public void setAttribute(String s, String s1) {
        this.attributes.put(s, s1);
    }

    public void setComment(String s) {
        this.comment = new String(s);
    }

    public void setData(Object s) {
        this.data = new String(s.toString()).trim();
    }

    public void setName(String s) {
        this.name = new String(s);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name=" + this.name);
        buffer.append(" Data=" + this.data);
        Enumeration e = this.getChildren();
        while (e.hasMoreElements()) {
            Element el = (Element)e.nextElement();
            buffer.append("  " + el.toString());
        }
        return buffer.toString();
    }
}

