/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.conf;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.slide.util.conf.AbstractConfiguration;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.util.conf.Element;

public class ConfigurationElement
extends AbstractConfiguration {
    private Element content;
    private Vector children;

    public ConfigurationElement(Element content) {
        this.content = content;
        this.children = new Vector();
        try {
            Enumeration e = content.getChildren();
            while (e.hasMoreElements()) {
                this.children.addElement(new ConfigurationElement((Element)e.nextElement()));
            }
        }
        catch (ConfigurationException configurationException) {}
    }

    public String getAttribute(String name) throws ConfigurationException {
        String attribute = this.content.getAttributeValue(name);
        if (attribute == null) {
            throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\"", this);
        }
        return attribute;
    }

    public Configuration getConfiguration(String name) throws ConfigurationException {
        int index = name.indexOf(46);
        if (index == -1) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                Configuration c = (Configuration)e.nextElement();
                if (!c.getName().equals(name)) continue;
                return c;
            }
        } else {
            return this.getConfiguration(name.substring(0, index)).getConfiguration(name.substring(index + 1));
        }
        throw new ConfigurationException("No Configuration named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\"", this);
    }

    public Enumeration getConfigurations(String name) throws ConfigurationException {
        int index = name.indexOf(46);
        if (index == -1) {
            Vector<Configuration> v = new Vector<Configuration>();
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                Configuration c = (Configuration)e.nextElement();
                if (!c.getName().equals(name)) continue;
                v.addElement(c);
            }
            return v.elements();
        }
        return this.getConfiguration(name.substring(0, index)).getConfigurations(name.substring(index + 1));
    }

    public String getName() {
        return this.content.getName();
    }

    public String getValue() {
        return this.content.getData();
    }
}

