/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.transaction;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.transaction.SlideTransactionManager;
import org.apache.slide.transaction.SlideXid;
import org.apache.slide.util.Messages;

public final class SlideTransaction
implements Transaction {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : (class$org$apache$slide$transaction$SlideTransaction = SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction"))).getName();
    private SlideXid xid;
    private Hashtable branches = new Hashtable();
    private Hashtable activeBranches = new Hashtable();
    private Vector enlistedResources = new Vector();
    private Hashtable suspendedResources = new Hashtable();
    private int status = 0;
    private Vector synchronizationObjects = new Vector();
    private int branchCounter = 1;
    private static int globalCreatedTransactions = 0;
    private int currentTransactionNumber = ++globalCreatedTransactions;
    private String currentThreadName = Thread.currentThread().getName();
    private SlideTransactionManager transactionManager;
    static /* synthetic */ Class class$org$apache$slide$transaction$SlideTransaction;

    public SlideTransaction(SlideTransactionManager transactionManager) {
        this.xid = new SlideXid((String.valueOf(this.currentThreadName) + "-" + System.currentTimeMillis() + "-" + this.currentTransactionNumber).getBytes(), 0, new byte[0]);
        this.transactionManager = transactionManager;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        String logMessage;
        XAResource resourceManager;
        Object key;
        if (this.status == 1) {
            this.rollback();
            return;
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        Enumeration syncList = this.synchronizationObjects.elements();
        while (syncList.hasMoreElements()) {
            Synchronization sync = (Synchronization)syncList.nextElement();
            sync.beforeCompletion();
        }
        Vector<Throwable> exceptions = new Vector<Throwable>();
        boolean fail = false;
        Enumeration<Object> enumeration = this.branches.keys();
        if (this.enlistedResources.size() == 1) {
            this.status = 8;
            while (enumeration.hasMoreElements()) {
                key = enumeration.nextElement();
                resourceManager = (XAResource)this.branches.get(key);
                try {
                    if (!fail) {
                        resourceManager.commit(this.xid, true);
                        continue;
                    }
                    resourceManager.rollback(this.xid);
                }
                catch (Throwable e) {
                    logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction")).getName()) + ".commitFail", resourceManager, SlideTransaction.getXAErrorCode(e), this.toString());
                    this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 4);
                    exceptions.addElement(e);
                    fail = true;
                    this.status = 1;
                }
            }
            this.status = !fail ? 3 : 4;
        } else if (this.enlistedResources.size() != 0) {
            this.status = 7;
            while (!fail && enumeration.hasMoreElements()) {
                key = enumeration.nextElement();
                resourceManager = (XAResource)this.branches.get(key);
                try {
                    resourceManager.prepare((Xid)key);
                }
                catch (Throwable e) {
                    logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction")).getName()) + ".prepareFail", resourceManager, SlideTransaction.getXAErrorCode(e), this.toString());
                    this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 4);
                    exceptions.addElement(e);
                    fail = true;
                    this.status = 1;
                }
            }
            if (!fail) {
                this.status = 2;
            }
            if (fail) {
                this.status = 9;
                fail = false;
                enumeration = this.branches.keys();
                while (enumeration.hasMoreElements()) {
                    key = enumeration.nextElement();
                    resourceManager = (XAResource)this.branches.get(key);
                    try {
                        resourceManager.rollback((Xid)key);
                    }
                    catch (Throwable e) {
                        logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction")).getName()) + ".rollbackFail", resourceManager, SlideTransaction.getXAErrorCode(e), this.toString());
                        this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 4);
                        exceptions.addElement(e);
                        fail = true;
                    }
                }
                this.status = 4;
            } else {
                this.status = 8;
                enumeration = this.branches.keys();
                while (enumeration.hasMoreElements()) {
                    key = enumeration.nextElement();
                    resourceManager = (XAResource)this.branches.get(key);
                    try {
                        resourceManager.commit((Xid)key, false);
                    }
                    catch (Throwable e) {
                        logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction")).getName()) + ".commitFail", resourceManager, SlideTransaction.getXAErrorCode(e), this.toString());
                        this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 4);
                        exceptions.addElement(e);
                        fail = true;
                    }
                }
                this.status = 3;
            }
        }
        syncList = this.synchronizationObjects.elements();
        while (syncList.hasMoreElements()) {
            Synchronization sync = (Synchronization)syncList.nextElement();
            sync.afterCompletion(this.status);
        }
        enumeration = exceptions.elements();
        if (enumeration.hasMoreElements()) {
            if (this.status == 4 && !fail) {
                throw new RollbackException();
            }
            if (this.status == 4) {
                throw new HeuristicRollbackException();
            }
            if (this.status == 3 && fail) {
                throw new HeuristicMixedException();
            }
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        Xid xid = (Xid)this.activeBranches.get(xaRes);
        if (xid == null) {
            throw new IllegalStateException();
        }
        this.activeBranches.remove(xaRes);
        if (this.transactionManager.getLogger().isEnabled(LOG_CHANNEL, 7)) {
            String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : (class$org$apache$slide$transaction$SlideTransaction = SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction"))).getName()) + ".delist", xaRes, SlideTransaction.getXAFlag(flag), this.toString());
            this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 7);
        }
        XAException exception = null;
        try {
            xaRes.end(xid, flag);
        }
        catch (XAException e) {
            exception = e;
        }
        if (exception != null) {
            String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : (class$org$apache$slide$transaction$SlideTransaction = SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction"))).getName()) + ".delistFail", xaRes, SlideTransaction.getXAErrorCode(exception), this.toString());
            this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 4);
            return false;
        }
        if (flag == 0x2000000) {
            this.suspendedResources.put(xaRes, xid);
        }
        return true;
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 1) {
            throw new RollbackException();
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        Xid activeXid = (Xid)this.activeBranches.get(xaRes);
        if (activeXid != null) {
            return false;
        }
        boolean alreadyEnlisted = false;
        int flag = 0;
        Xid branchXid = (Xid)this.suspendedResources.get(xaRes);
        if (branchXid == null) {
            Enumeration enumeration = this.enlistedResources.elements();
            while (!alreadyEnlisted && enumeration.hasMoreElements()) {
                XAResource resourceManager = (XAResource)enumeration.nextElement();
                try {
                    if (!resourceManager.isSameRM(xaRes)) continue;
                    flag = 0x200000;
                    alreadyEnlisted = true;
                }
                catch (XAException xAException) {}
            }
            branchXid = this.xid.newBranch(this.branchCounter++);
        } else {
            alreadyEnlisted = true;
            flag = 0x8000000;
            this.suspendedResources.remove(xaRes);
        }
        if (this.transactionManager.getLogger().isEnabled(LOG_CHANNEL, 7)) {
            String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : (class$org$apache$slide$transaction$SlideTransaction = SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction"))).getName()) + ".enlist", xaRes, SlideTransaction.getXAFlag(flag), this.toString());
            this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 7);
        }
        try {
            xaRes.start(branchXid, flag);
        }
        catch (XAException e) {
            String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : (class$org$apache$slide$transaction$SlideTransaction = SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction"))).getName()) + ".enlistFail", xaRes, SlideTransaction.getXAErrorCode(e), this.toString());
            this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 4);
            return false;
        }
        if (!alreadyEnlisted) {
            this.enlistedResources.addElement(xaRes);
        }
        this.branches.put(branchXid, xaRes);
        this.activeBranches.put(xaRes, branchXid);
        return true;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public static String getXAErrorCode(Throwable throww) {
        String result = null;
        if (throww instanceof XAException) {
            result = SlideTransaction.getXAErrorCode((XAException)throww);
        } else {
            StringWriter sw = new StringWriter();
            throww.printStackTrace(new PrintWriter((Writer)sw, true));
            result = sw.toString();
        }
        return result;
    }

    public static String getXAErrorCode(XAException xae) {
        switch (xae.errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 100: {
                return "XA_RBBASE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBBEADLOCK";
            }
            case 107: {
                return "XA_RBEND";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "UNKNOWN";
    }

    public static String getXAFlag(int flag) {
        switch (flag) {
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x40000000: {
                return "TMONEPHASE";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
        }
        return "UNKNOWN";
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 1) {
            throw new RollbackException();
        }
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        this.synchronizationObjects.addElement(sync);
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        if (this.status != 0 && this.status != 1) {
            throw new IllegalStateException();
        }
        Vector<Throwable> exceptions = new Vector<Throwable>();
        Enumeration enumeration = this.branches.keys();
        this.status = 9;
        while (enumeration.hasMoreElements()) {
            Xid xid = (Xid)enumeration.nextElement();
            XAResource resourceManager = (XAResource)this.branches.get(xid);
            try {
                resourceManager.rollback(xid);
            }
            catch (Throwable e) {
                exceptions.addElement(e);
                String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransaction != null ? class$org$apache$slide$transaction$SlideTransaction : SlideTransaction.class$("org.apache.slide.transaction.SlideTransaction")).getName()) + ".rollbackFail", resourceManager, SlideTransaction.getXAErrorCode(e), this.toString());
                this.transactionManager.getLogger().log(logMessage, LOG_CHANNEL, 4);
            }
        }
        this.status = 4;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    public String toString() {
        return "Transaction " + this.currentTransactionNumber + " xid " + this.xid + " in thread " + this.currentThreadName + (this.currentThreadName.equals(Thread.currentThread().getName()) ? "" : " current= " + Thread.currentThread().getName());
    }
}

