/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractSimpleService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.impl.rdbms.JDBCAwareInputStream;

public class JDBCContentStore
extends AbstractSimpleService
implements ContentStore {
    public static final int BUFFER_SIZE = 2048;
    public static final String CHARACTER_ENCODING = "8859_1";
    protected static final int REVISION_URI = 1;
    protected static final int REVISION_NUMBER = 2;
    protected static final int REVISION_CONTENT = 3;
    protected Connection connection;
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected boolean alreadyEnlisted = false;

    protected void closeStatement(Statement statement) {
        block2: {
            if (statement == null) break block2;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        super.commit(xid, onePhase);
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            throw new XAException(101);
        }
        this.alreadyEnlisted = false;
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        this.getLogger().log("Connecting to \"" + this.url + "\" as user \"" + this.user + "\"", this.LOG_CHANNEL, 6);
        try {
            this.connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException e) {
            this.getLogger().log("Connecting to \"" + this.url + "\" as user \"" + this.user + "\" failed", this.LOG_CHANNEL, 2);
            this.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceConnectionFailedException((Service)this, e);
        }
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {}
        Statement statement = null;
        try {
            try {
                statement = this.connection.createStatement();
                String[] statements = this.getDatabaseCreateStatements();
                int i = 0;
                while (i < statements.length) {
                    statement.execute(statements[i]);
                    ++i;
                }
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException sQLException2) {
                }
            }
            Object var3_5 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        this.alreadyEnlisted = false;
    }

    protected synchronized void connectIfNeededAndPossible() {
        try {
            this.connectIfNeeded();
        }
        catch (Throwable throwable) {}
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        long contentLength = revisionDescriptor.getContentLength();
        PreparedStatement selectStatement = null;
        try {
            try {
                selectStatement = this.connection.prepareStatement("select 1 from revisioncontent where uri = ? and xnumber = ?");
                selectStatement.setString(1, revisionUri);
                selectStatement.setString(2, revisionNumber);
                ResultSet rs = selectStatement.executeQuery();
                if (rs.next()) {
                    rs.close();
                    throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                rs.close();
                this.storeContent(revisionUri, revisionNumber, revisionDescriptor, revisionContent);
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (IOException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (RevisionAlreadyExistException e) {
                this.getLogger().log("RevisionNotFoundException encountered for " + revisionUri + " revision " + revisionNumber, this.LOG_CHANNEL, 4);
                throw e;
            }
            catch (Exception e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            Object var10_13 = null;
            this.closeStatement(selectStatement);
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.closeStatement(selectStatement);
            throw throwable;
        }
    }

    public synchronized void disconnect() throws ServiceDisconnectionFailedException {
        this.getLogger().log("Disconnecting from \"" + this.url + "\" as user \"" + this.user + "\"", this.LOG_CHANNEL, 6);
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
        }
        catch (SQLException e) {
            this.getLogger().log("Disconnecting from \"" + this.url + "\" as user \"" + this.user + "\" failed", this.LOG_CHANNEL, 2);
            this.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceDisconnectionFailedException((Service)this, e);
        }
    }

    protected String getDatabaseConnectionTestStatement() {
        return "select 1 from revisioncontent where uri is null";
    }

    protected String[] getDatabaseCreateStatements() {
        String[] statements = new String[]{"create table revisioncontent(uri varchar(65536), xnumber varchar(20), content LONGVARBINARY)"};
        return statements;
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        try {
            token.getLogger().log("Loading and registering driver: " + this.driver, this.LOG_CHANNEL, 6);
            Class<?> driverClass = Class.forName(this.driver);
            Driver databaseDriver = (Driver)driverClass.newInstance();
            DriverManager.registerDriver(databaseDriver);
        }
        catch (ClassNotFoundException e) {
            token.getLogger().log("Loading and registering driver " + this.driver + " failed", this.LOG_CHANNEL, 2);
            token.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (InstantiationException e) {
            token.getLogger().log("Loading and registering driver " + this.driver + " failed", this.LOG_CHANNEL, 2);
            token.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (IllegalAccessException e) {
            token.getLogger().log("Loading and registering driver " + this.driver + " failed", this.LOG_CHANNEL, 2);
            token.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (SQLException e) {
            token.getLogger().log("Loading and registering driver " + this.driver + " failed", this.LOG_CHANNEL, 2);
            token.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (ClassCastException e) {
            token.getLogger().log("Loading and registering driver " + this.driver + " failed", this.LOG_CHANNEL, 2);
            token.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            token.getLogger().log("Loading and registering driver " + this.driver + " failed", this.LOG_CHANNEL, 2);
            token.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
    }

    public boolean isConnected() throws ServiceAccessException {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                return false;
            }
            PreparedStatement statement = this.connection.prepareStatement(this.getDatabaseConnectionTestStatement());
            statement.executeQuery();
            statement.close();
            return true;
        }
        catch (SQLException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    protected void removeContent(String revisionUri, String revisionNumber) throws SQLException {
        PreparedStatement deleteStatement = this.connection.prepareStatement("delete from revisioncontent where uri = ? and xnumber = ?");
        deleteStatement.setString(1, revisionUri);
        deleteStatement.setString(2, revisionNumber);
        deleteStatement.executeUpdate();
        deleteStatement.close();
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        try {
            this.removeContent(revisionUri, revisionNumber);
        }
        catch (Exception e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            this.connectIfNeededAndPossible();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    public void reset() throws ServiceResetFailedException {
        try {
            this.connectIfNeeded();
            Statement statement = this.connection.createStatement();
            String s = "drop table revisioncontent";
            statement.execute(s);
            statement.close();
            this.disconnect();
        }
        catch (SQLException e) {
            throw new ServiceResetFailedException(this, e.getMessage());
        }
        catch (ServiceAccessException e) {
            throw new ServiceResetFailedException(this, e.getMessage());
        }
        catch (ServiceConnectionFailedException e) {
            throw new ServiceResetFailedException(this, e.getMessage());
        }
        catch (ServiceDisconnectionFailedException e) {
            throw new ServiceResetFailedException(this, e.getMessage());
        }
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        NodeRevisionContent result = null;
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        try {
            PreparedStatement selectStatement = this.connection.prepareStatement("select * from revisioncontent where uri = ? and xnumber = ?");
            selectStatement.setString(1, revisionUri);
            selectStatement.setString(2, revisionNumber);
            ResultSet rs = selectStatement.executeQuery();
            if (!rs.next()) {
                rs.close();
                selectStatement.close();
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            InputStream is = rs.getBinaryStream(3);
            if (is == null) {
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            result = new NodeRevisionContent();
            result.setContent(is);
            result.setContent(new JDBCAwareInputStream(is, selectStatement));
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            this.connectIfNeededAndPossible();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (RevisionNotFoundException e) {
            this.getLogger().log("RevisionNotFoundException encountered for " + revisionUri + " revision " + revisionNumber, this.LOG_CHANNEL, 4);
            throw e;
        }
        catch (Exception e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            this.connectIfNeededAndPossible();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        return result;
    }

    public void rollback(Xid xid) throws XAException {
        super.rollback(xid);
        try {
            this.connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new XAException(7);
        }
        this.alreadyEnlisted = false;
    }

    public synchronized void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.driver = (String)parameters.get("driver");
        this.url = (String)parameters.get("url");
        if (!this.url.startsWith("jdbc:")) {
            this.url = "jdbc:" + this.url;
        }
        this.user = (String)parameters.get("user");
        if (this.user == null) {
            this.user = new String();
        }
        this.password = (String)parameters.get("password");
        if (this.password == null) {
            this.password = new String();
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        super.start(xid, flags);
        if (!this.alreadyEnlisted) {
            try {
                this.connectIfNeeded();
                this.connection.rollback();
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.alreadyEnlisted = true;
        }
    }

    protected void storeContent(String revisionUri, String revisionNumber, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException, SQLException {
        PreparedStatement insertStatement = this.connection.prepareStatement("insert into revisioncontent values(?, ?, ?)");
        insertStatement.setString(1, revisionUri);
        insertStatement.setString(2, revisionNumber);
        InputStream is = revisionContent.streamContent();
        if (is != null) {
            Object os = null;
            byte[] buffer = new byte[2048];
            long position = 0L;
            long contentLength = revisionDescriptor.getContentLength();
            File tempFile = null;
            String tempFileName = null;
            if (contentLength == -1L) {
                try {
                    int nChar;
                    tempFileName = String.valueOf(revisionUri) + "-" + revisionNumber;
                    tempFileName = tempFileName.replace('/', '.');
                    int tempFileNameLength = tempFileName.length();
                    if (tempFileNameLength > 200) {
                        tempFileName = tempFileName.substring(tempFileNameLength - 200, tempFileNameLength);
                    }
                    tempFile = File.createTempFile(tempFileName, null);
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    while ((nChar = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, nChar);
                        position += (long)nChar;
                    }
                    fos.close();
                    is = new FileInputStream(tempFile);
                    contentLength = tempFile.length();
                }
                catch (IOException ex) {
                    this.getLogger().log(String.valueOf(ex.toString()) + " during the calculation of the content length.", this.LOG_CHANNEL, 2);
                    this.getLogger().log("tempFileName: " + tempFileName, this.LOG_CHANNEL, 2);
                    this.getLogger().log("tempFile: " + tempFile.getAbsolutePath(), this.LOG_CHANNEL, 2);
                    throw ex;
                }
            }
            insertStatement.setBinaryStream(3, is, (int)contentLength);
            insertStatement.executeUpdate();
            revisionDescriptor.setContentLength(contentLength);
            if (tempFile != null) {
                is.close();
                tempFile.delete();
            }
        }
        insertStatement.close();
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        String revisionUri = uri.toString();
        String revisionNumber = revisionDescriptor.getRevisionNumber().toString();
        PreparedStatement selectStatement = null;
        try {
            try {
                selectStatement = this.connection.prepareStatement("select 1 from revisioncontent where uri = ? and xnumber = ?");
                selectStatement.setString(1, revisionUri);
                selectStatement.setString(2, revisionNumber);
                ResultSet rs = selectStatement.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    selectStatement.close();
                    throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                }
                rs.close();
                this.removeContent(revisionUri, revisionNumber);
                this.storeContent(revisionUri, revisionNumber, revisionDescriptor, revisionContent);
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (IOException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            catch (RevisionNotFoundException e) {
                this.getLogger().log("RevisionNotFoundException encountered for " + revisionUri + " revision " + revisionNumber, this.LOG_CHANNEL, 4);
                throw e;
            }
            catch (Exception e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
            Object var8_12 = null;
            this.closeStatement(selectStatement);
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.closeStatement(selectStatement);
            throw throwable;
        }
    }
}

