/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.db;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.torque.om.BaseObject;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.User;
import org.apache.turbine.om.security.peer.TurbineUserPeer;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.PasswordMismatchException;
import org.apache.turbine.util.security.UnknownEntityException;

public class DBUserManager
implements UserManager {
    public boolean accountExists(User user) throws DataBackendException {
        return this.accountExists(user.getUserName());
    }

    public boolean accountExists(String username) throws DataBackendException {
        List users;
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)username);
        try {
            users = TurbineUserPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to check account's presence", e);
        }
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + username + "'");
        }
        return users.size() == 1;
    }

    public User retrieve(String username) throws UnknownEntityException, DataBackendException {
        List users;
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)username);
        try {
            users = TurbineUserPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to retrieve user '" + username + "'", e);
        }
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + username + "'");
        }
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        throw new UnknownEntityException("Unknown user '" + username + "'");
    }

    public User[] retrieve(Criteria criteria) throws DataBackendException {
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Criteria.Criterion[] criterion = criteria.getCriterion(key).getAttachedCriterion();
            int i = 0;
            while (i < criterion.length) {
                String table = criterion[i].getTable();
                if (table == null || "".equals(table)) {
                    criterion[i].setTable(TurbineUserPeer.getTableName());
                }
                ++i;
            }
        }
        List users = new ArrayList(0);
        try {
            users = TurbineUserPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to retrieve users", e);
        }
        return users.toArray(new User[0]);
    }

    public User retrieve(String username, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        User user = this.retrieve(username);
        this.authenticate(user, password);
        return user;
    }

    public void store(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        Criteria criteria = TurbineUserPeer.buildCriteria(user);
        try {
            TurbineUserPeer.doUpdate(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to save user object", e);
        }
    }

    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        String encrypted = TurbineSecurity.encryptPassword(password);
        if (!user.getPassword().equals(encrypted)) {
            throw new PasswordMismatchException("The passwords do not match");
        }
    }

    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        String encrypted = TurbineSecurity.encryptPassword(oldPassword);
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        if (!user.getPassword().equals(encrypted)) {
            throw new PasswordMismatchException("The supplied old password for '" + user.getUserName() + "' was incorrect");
        }
        user.setPassword(TurbineSecurity.encryptPassword(newPassword));
        this.store(user);
    }

    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        user.setPassword(TurbineSecurity.encryptPassword(password));
        this.store(user);
    }

    public void createAccount(User user, String initialPassword) throws EntityExistsException, DataBackendException {
        if (this.accountExists(user)) {
            throw new EntityExistsException("The account '" + user.getUserName() + "' already exists");
        }
        String encrypted = TurbineSecurity.encryptPassword(initialPassword);
        user.setPassword(encrypted);
        Criteria criteria = TurbineUserPeer.buildCriteria(user);
        try {
            ((BaseObject)user).setPrimaryKey(BasePeer.doInsert((Criteria)criteria));
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to create account '" + user.getUserName() + "'", e);
        }
    }

    public void removeAccount(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)user.getUserName());
        try {
            BasePeer.doDelete((Criteria)criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to remove account '" + user.getUserName() + "'", e);
        }
    }
}

