/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.jsp.util.JspLink;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.template.BaseTemplateEngineService;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class TurbineJspService
extends BaseTemplateEngineService
implements JspService {
    private String[] templatePaths;
    private String[] relativeTemplatePaths;
    private int bufferSize;

    public void init() throws InitializationException {
        ServletConfig conf = Turbine.getTurbineServletConfig();
        this.init(conf);
    }

    public void init(ServletConfig config) throws InitializationException {
        try {
            this.initJsp();
            this.registerConfiguration("jsp");
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineJspService failed to initialize", e);
        }
    }

    public void addDefaultObjects(RunData data) {
        HttpServletRequest req = data.getRequest();
        req.setAttribute("link", (Object)new JspLink(data));
        req.setAttribute("rundata", (Object)data);
    }

    public int getDefaultBufferSize() {
        return this.bufferSize;
    }

    public void handleRequest(RunData data, String filename) throws TurbineException {
        this.handleRequest(data, filename, false);
    }

    public void handleRequest(RunData data, String filename, boolean isForward) throws TurbineException {
        String relativeTemplateName = this.getRelativeTemplateName(filename);
        if (relativeTemplateName == null) {
            throw new TurbineException("Template " + filename + " not found in template paths");
        }
        RequestDispatcher dispatcher = data.getServletContext().getRequestDispatcher(relativeTemplateName);
        try {
            if (isForward) {
                dispatcher.forward((ServletRequest)data.getRequest(), (ServletResponse)data.getResponse());
            } else {
                data.getOut().flush();
                dispatcher.include((ServletRequest)data.getRequest(), (ServletResponse)data.getResponse());
            }
        }
        catch (Exception e) {
            try {
                data.getOut().print("Error encountered processing a template: " + filename);
                e.printStackTrace(data.getOut());
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new TurbineException("Error encountered processing a template:" + filename, e);
        }
    }

    private void initJsp() throws Exception {
        ServletContext context = TurbineServlet.getServletContext();
        Configuration config = this.getConfiguration();
        this.templatePaths = TurbineTemplate.translateTemplatePaths(config.getStringArray("templates"));
        this.relativeTemplatePaths = config.getStringArray("templates");
        int i = 0;
        while (i < this.relativeTemplatePaths.length) {
            if (!this.relativeTemplatePaths[i].startsWith("/")) {
                this.relativeTemplatePaths[i] = "/" + this.relativeTemplatePaths[i];
            }
            ++i;
        }
        this.bufferSize = config.getInt("buffer.size", 8192);
        this.registerConfiguration("jsp");
    }

    public boolean templateExists(String template) {
        return TurbineTemplate.templateExists(template, this.templatePaths);
    }

    public String getRelativeTemplateName(String template) {
        String[] testTemplatePath = new String[1];
        int i = 0;
        while (i < this.relativeTemplatePaths.length) {
            testTemplatePath[0] = TurbineServlet.getRealPath(this.relativeTemplatePaths[i]);
            if (TurbineTemplate.templateExists(template, testTemplatePath)) {
                return this.relativeTemplatePaths[i] + template;
            }
            ++i;
        }
        return null;
    }
}

