/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import java.io.Serializable;
import java.util.Date;

public class Cookie
implements Serializable {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private Date expiryDate;
    private String path;
    private boolean isSecure = false;

    public Cookie(String theDomain, String theName, String theValue) {
        if (theDomain == null) {
            throw new NullPointerException("missing cookie domain");
        }
        if (theName == null) {
            throw new NullPointerException("missing cookie name");
        }
        if (theValue == null) {
            throw new NullPointerException("missing cookie value");
        }
        this.setDomain(theDomain);
        this.setName(theName);
        this.setValue(theValue);
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String theValue) {
        this.value = theValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String theComment) {
        this.comment = theComment;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date theExpiryDate) {
        this.expiryDate = theExpiryDate;
    }

    public boolean isToBeDiscarded() {
        return this.getExpiryDate() != null;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String theDomain) {
        int ndx = theDomain.indexOf(":");
        if (ndx != -1) {
            theDomain = theDomain.substring(0, ndx);
        }
        this.domain = theDomain.toLowerCase();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String thePath) {
        this.path = thePath;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public boolean isExpired() {
        return this.getExpiryDate() != null && this.getExpiryDate().getTime() <= System.currentTimeMillis();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getValue().hashCode() + this.getDomain().hashCode();
    }

    public boolean equals(Object theObject) {
        if (theObject != null && theObject instanceof Cookie) {
            Cookie other = (Cookie)theObject;
            return this.getName().equals(other.getName()) && this.getPath().equals(other.getPath()) && this.getDomain().equals(other.getDomain());
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("name = [" + this.getName() + "], ");
        buffer.append("value = [" + this.getValue() + "], ");
        buffer.append("domain = [" + this.getDomain() + "], ");
        buffer.append("path = [" + this.getPath() + "], ");
        buffer.append("isSecure = [" + this.isSecure() + "], ");
        buffer.append("comment = [" + this.getComment() + "], ");
        buffer.append("expiryDate = [" + this.getExpiryDate() + "]");
        return buffer.toString();
    }
}

