/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.cactus.ServletTestRequest;
import org.apache.cactus.WebResponse;
import org.apache.cactus.client.AbstractHttpClient;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.cactus.util.log.Log;
import org.apache.cactus.util.log.LogService;

public abstract class AbstractTestCase
extends TestCase {
    protected static final String TEST_METHOD_PREFIX = "test";
    protected static final String BEGIN_METHOD_PREFIX = "begin";
    protected static final String END_METHOD_PREFIX = "end";
    public String currentTestMethod = this.name();
    protected Log logger;
    static /* synthetic */ Class class$org$apache$cactus$WebRequest;
    static /* synthetic */ Class class$java$net$URLConnection;

    public AbstractTestCase(String theName) {
        super(theName);
    }

    private String getBaseMethodName() {
        if (!this.name().startsWith(TEST_METHOD_PREFIX)) {
            throw new RuntimeException("bad name [" + this.name() + "]. It should start with [" + TEST_METHOD_PREFIX + "].");
        }
        return this.name().substring(TEST_METHOD_PREFIX.length());
    }

    protected String getBeginMethodName() {
        return BEGIN_METHOD_PREFIX + this.getBaseMethodName();
    }

    protected String getEndMethodName() {
        return END_METHOD_PREFIX + this.getBaseMethodName();
    }

    protected void callBeginMethod(ServletTestRequest theRequest) throws Throwable {
        Method[] methods = ((Object)((Object)this)).getClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(this.getBeginMethodName())) {
                Class<?>[] parameters;
                if (!methods[i].getReturnType().getName().equals("void")) {
                    Assert.fail((String)("The begin method [" + methods[i].getName() + "] should return void and not [" + methods[i].getReturnType().getName() + "]"));
                }
                if (!Modifier.isPublic(methods[i].getModifiers())) {
                    Assert.fail((String)("Method [" + methods[i].getName() + "] should be declared public"));
                }
                if ((parameters = methods[i].getParameterTypes()).length != 1) {
                    Assert.fail((String)("The begin method [" + methods[i].getName() + "] must accept a single parameter derived from " + "class [" + (class$org$apache$cactus$WebRequest == null ? AbstractTestCase.class$("org.apache.cactus.WebRequest") : class$org$apache$cactus$WebRequest).getName() + "], " + "but " + parameters.length + " parameters were found"));
                } else if (!(class$org$apache$cactus$WebRequest == null ? AbstractTestCase.class$("org.apache.cactus.WebRequest") : class$org$apache$cactus$WebRequest).isAssignableFrom(parameters[0])) {
                    Assert.fail((String)("The begin method [" + methods[i].getName() + "] must accept a single parameter derived from " + "class [" + (class$org$apache$cactus$WebRequest == null ? AbstractTestCase.class$("org.apache.cactus.WebRequest") : class$org$apache$cactus$WebRequest).getName() + "], " + "but found a [" + parameters[0].getName() + "] " + "parameter instead"));
                }
                try {
                    methods[i].invoke((Object)this, theRequest);
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throw e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throw e;
                }
            }
            ++i;
        }
    }

    protected void callEndMethod(ServletTestRequest theRequest, HttpURLConnection theConnection) throws Throwable {
        Method methodToCall = null;
        Object paramObject = null;
        Method[] methods = ((Object)((Object)this)).getClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(this.getEndMethodName())) {
                Class<?>[] parameters;
                if (!methods[i].getReturnType().getName().equals("void")) {
                    Assert.fail((String)("The end method [" + methods[i].getName() + "] should return void and not [" + methods[i].getReturnType().getName() + "]"));
                }
                if (!Modifier.isPublic(methods[i].getModifiers())) {
                    Assert.fail((String)("Method [" + methods[i].getName() + "] should be declared public"));
                }
                if ((parameters = methods[i].getParameterTypes()).length != 1) {
                    Assert.fail((String)("The end method [" + methods[i].getName() + "] must only have a single parameter"));
                }
                if (parameters[0].getName().equals("com.meterware.httpunit.WebResponse")) {
                    paramObject = this.createHttpUnitWebResponse(theConnection);
                } else if (parameters[0].getName().equals("org.apache.cactus.WebResponse")) {
                    paramObject = new WebResponse(theRequest, theConnection);
                } else if (parameters[0].getName().equals("java.net.HttpURLConnection")) {
                    paramObject = theConnection;
                } else {
                    Assert.fail((String)("The end method [" + methods[i].getName() + "] has a bad parameter of type [" + parameters[0].getName() + "]"));
                }
                if (methodToCall != null) {
                    Assert.fail((String)("There can only be one end method per test case. Test case [" + this.currentTestMethod + "] has two at least !"));
                }
                methodToCall = methods[i];
            }
            ++i;
        }
        if (methodToCall != null) {
            try {
                methodToCall.invoke((Object)this, paramObject);
            }
            catch (InvocationTargetException e) {
                e.fillInStackTrace();
                throw e.getTargetException();
            }
            catch (IllegalAccessException e) {
                e.fillInStackTrace();
                throw e;
            }
        }
    }

    private Object createHttpUnitWebResponse(HttpURLConnection theConnection) {
        Object webResponse;
        try {
            Class<?> responseClass = Class.forName("com.meterware.httpunit.WebResponse");
            Method method = responseClass.getMethod("newResponse", class$java$net$URLConnection == null ? (class$java$net$URLConnection = AbstractTestCase.class$("java.net.URLConnection")) : class$java$net$URLConnection);
            webResponse = method.invoke(null, theConnection);
        }
        catch (Exception e) {
            throw new ChainedRuntimeException("Error calling [public static com.meterware.httpunit.WebResponse com.meterware.httpunit.WebResponse.newResponse(java.net.URLConnection) throws java.io.IOException]", e);
        }
        return webResponse;
    }

    public void runBare() throws Throwable {
        if (!LogService.getInstance().isInitialized()) {
            LogService.getInstance().init("/log_client.properties");
        }
        this.logger = LogService.getInstance().getLog(((Object)((Object)this)).getClass().getName());
        try {
            this.runTest();
        }
        catch (Throwable t) {
            this.logger.debug("Exception in test", t);
            throw t;
        }
    }

    protected abstract void runTest() throws Throwable;

    protected void runGenericTest(AbstractHttpClient theHttpClient) throws Throwable {
        this.logger.entry("runGenericTest(...)");
        this.logger.debug("Test case = " + this.currentTestMethod);
        ServletTestRequest request = new ServletTestRequest();
        this.callBeginMethod(request);
        request.addParameter("ServletTestRedirector_TestClass", ((Object)((Object)this)).getClass().getName());
        request.addParameter("ServletTestRedirector_TestMethod", this.name());
        request.addParameter("ServletTestRedirector_AutomaticSession", new Boolean(request.getAutomaticSession()).toString());
        if (request.getURL() != null) {
            request.getURL().saveToRequest(request);
        }
        HttpURLConnection connection = theHttpClient.doTest(request);
        this.callEndMethod(request, connection);
        connection.getInputStream().close();
        this.logger.exit("runGenericTest");
    }

    public void runBareServerTest() throws Throwable {
        if (this.logger == null) {
            this.logger = LogService.getInstance().getLog(((Object)((Object)this)).getClass().getName());
        }
        this.logger.entry("runBareServerTest()");
        this.setUp();
        try {
            this.runServerTest();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.tearDown();
            throw throwable;
        }
        this.tearDown();
        this.logger.exit("runBareServerTest");
    }

    protected void runServerTest() throws Throwable {
        this.logger.entry("runServerTest()");
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(this.currentTestMethod, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("Method [" + this.currentTestMethod + "()] does not exist for class [" + ((Object)((Object)this)).getClass().getName() + "]."));
        }
        if (runMethod != null && !Modifier.isPublic(runMethod.getModifiers())) {
            Assert.fail((String)("Method [" + this.currentTestMethod + "()] should be public"));
        }
        try {
            runMethod.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
        this.logger.exit("runServerTest");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

