/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.util.parser;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.util.parser.BaseValueParser;
import org.apache.fulcrum.util.parser.CookieParser;
import org.apache.log4j.Category;

public class DefaultCookieParser
extends BaseValueParser
implements CookieParser,
Recyclable {
    private HttpServletRequest request;
    private HttpServletResponse response;
    Category category = Category.getInstance((String)this.getClass().getName());

    public void dispose() {
        this.request = null;
        super.dispose();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setData(HttpServletRequest request, HttpServletResponse response) {
        this.clear();
        String enc = request.getCharacterEncoding();
        this.setCharacterEncoding(enc != null ? enc : "US-ASCII");
        Cookie[] cookies = request.getCookies();
        this.category.debug((Object)("Number of Cookies " + cookies.length));
        int i = 0;
        while (i < cookies.length) {
            String name = this.convert(cookies[i].getName());
            String value = cookies[i].getValue();
            this.category.debug((Object)("Adding " + name + "=" + value));
            this.add(name, value);
            ++i;
        }
        this.request = request;
        this.response = response;
    }

    public void set(String name, String value) {
        this.set(name, value, -1);
    }

    public void set(String name, String value, int seconds_age) {
        if (this.response == null) {
            throw new IllegalStateException("Servlet response not available");
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(seconds_age);
        cookie.setPath(this.request.getServletPath());
        this.response.addCookie(cookie);
    }

    public void unset(String name) {
        this.set(name, " ", 0);
    }
}

