/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.TurbineIntake;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.util.parser.ValueParser;
import org.apache.log4j.Category;

public class Intake
implements Recyclable {
    public static final String DEFAULT_KEY = "_0";
    private HashMap groups;
    private ValueParser pp;
    HashMap declaredGroups = new HashMap();
    StringBuffer allGroupsSB = new StringBuffer(256);
    StringBuffer groupSB = new StringBuffer(128);
    private Map pullMap;
    Category category = Category.getInstance((String)this.getClass().getName());
    private boolean disposed;

    public Intake() {
        String[] groupNames = TurbineIntake.getGroupNames();
        this.groups = new HashMap((int)(1.25 * (double)groupNames.length + 1.0));
        this.pullMap = new HashMap((int)(1.25 * (double)groupNames.length + 1.0));
        int i = groupNames.length - 1;
        while (i >= 0) {
            this.pullMap.put(groupNames[i], new PullHelper(groupNames[i]));
            --i;
        }
    }

    public void init(ValueParser pp) {
        int i;
        this.pp = pp;
        String[] groupKeys = pp.getStrings("intake-grp");
        String[] groupNames = null;
        if (groupKeys == null || groupKeys.length == 0) {
            groupNames = TurbineIntake.getGroupNames();
        } else {
            groupNames = new String[groupKeys.length];
            i = groupKeys.length - 1;
            while (i >= 0) {
                groupNames[i] = TurbineIntake.getGroupName(groupKeys[i]);
                --i;
            }
        }
        i = groupNames.length - 1;
        while (i >= 0) {
            try {
                ArrayList foundGroups = TurbineIntake.getGroup(groupNames[i]).getObjects(pp);
                if (foundGroups != null) {
                    Iterator iter = foundGroups.iterator();
                    while (iter.hasNext()) {
                        Group group = (Group)iter.next();
                        this.groups.put(group.getObjectKey(), group);
                    }
                }
            }
            catch (Exception e) {
                this.category.error((Object)e);
            }
            --i;
        }
    }

    public void addGroupsToParameters(ValueParser vp) {
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
                this.declaredGroups.put(group.getIntakeGroupName(), null);
                vp.add("intake-grp", group.getGID());
            }
            vp.add(group.getGID(), group.getOID());
        }
        this.declaredGroups.clear();
    }

    public String declareGroups() {
        this.allGroupsSB.setLength(0);
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            this.declareGroup((Group)i.next(), this.allGroupsSB);
        }
        return this.allGroupsSB.toString();
    }

    public String declareGroup(Group group) {
        this.groupSB.setLength(0);
        this.declareGroup(group, this.groupSB);
        return this.groupSB.toString();
    }

    public void declareGroup(Group group, StringBuffer sb) {
        if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
            this.declaredGroups.put(group.getIntakeGroupName(), null);
            sb.append("<input type=\"hidden\" name=\"").append("intake-grp\" value=\"").append(group.getGID()).append("\"/>\n");
        }
        group.appendHtmlFormInput(sb);
    }

    public void newForm() {
        this.declaredGroups.clear();
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            ((Group)i.next()).resetDeclared();
        }
    }

    public PullHelper get(String groupName) throws Exception {
        return (PullHelper)this.pullMap.get(groupName);
    }

    public boolean isAllValid() {
        boolean allValid = true;
        Iterator iter = this.groups.values().iterator();
        while (iter.hasNext()) {
            Group group = (Group)iter.next();
            allValid &= group.isAllValid();
        }
        return allValid;
    }

    public Group get(String groupName, String key) throws Exception {
        if (groupName == null) {
            throw new Exception("Intake.get: groupName == null");
        }
        if (key == null) {
            throw new Exception("Intake.get: key == null");
        }
        return this.get(groupName).setKey(key);
    }

    public Group get(String groupName, String key, boolean create) throws Exception {
        return this.get(groupName).setKey(key, create);
    }

    public void remove(Group group) {
        this.groups.remove(group.getObjectKey());
        group.removeFromRequest();
        TurbineIntake.releaseGroup(group);
    }

    public void removeAll() {
        Object[] allGroups = this.groups.values().toArray();
        int i = allGroups.length - 1;
        while (i >= 0) {
            Group group = (Group)allGroups[i];
            this.remove(group);
            --i;
        }
    }

    public void recycle() {
        this.disposed = false;
    }

    public void dispose() {
        Iterator iter = this.groups.values().iterator();
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            TurbineIntake.releaseGroup(g);
        }
        this.groups.clear();
        this.declaredGroups.clear();
        this.pp = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    static {
        DEFAULT_KEY = DEFAULT_KEY;
    }

    public class PullHelper {
        String groupName;

        private PullHelper(String groupName) {
            this.groupName = groupName;
        }

        public Group getDefault() throws Exception {
            return this.setKey(Intake.DEFAULT_KEY);
        }

        public Group setKey(String key) throws Exception {
            return this.setKey(key, true);
        }

        public Group setKey(String key, boolean create) throws Exception {
            Group g = null;
            String inputKey = TurbineIntake.getGroupKey(this.groupName) + key;
            if (Intake.this.groups.containsKey(inputKey)) {
                g = (Group)Intake.this.groups.get(inputKey);
            } else if (create) {
                g = TurbineIntake.getGroup(this.groupName);
                Intake.this.groups.put(inputKey, g);
                g.init(key, Intake.this.pp);
            }
            return g;
        }

        public Group mapTo(Retrievable obj) throws Exception {
            Group g = null;
            try {
                String inputKey = TurbineIntake.getGroupKey(this.groupName) + obj.getQueryKey();
                if (Intake.this.groups.containsKey(inputKey)) {
                    g = (Group)Intake.this.groups.get(inputKey);
                } else {
                    g = TurbineIntake.getGroup(this.groupName);
                    Intake.this.groups.put(inputKey, g);
                }
                return g.init(obj);
            }
            catch (Exception e) {
                Intake.this.category.error((Object)e);
                return null;
            }
        }
    }
}

